<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Receipt - {{ $sale->invoice_no }}</title>
<style>
/* ============================================
   THERMAL PRINTER STYLES (80mm / 58mm paper)
   ============================================ */

/* Print settings - removes browser headers/footers */
@page {
    size: 80mm auto; /* Width fixed, height grows with content */
    margin: 0;
}

@media print {
    html, body {
        width: 80mm;
        margin: 0 !important;
        padding: 0 !important;
    }
    body {
        padding: 2mm !important;
    }
    .no-print {
        display: none !important;
    }
    /* Force black text for thermal printers */
    * {
        color: #000 !important;
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }
}

/* Reset */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

/* Screen preview - mimics thermal paper */
body {
    font-family: 'Courier New', Courier, monospace;
    font-size: 12px;
    line-height: 1.3;
    width: 80mm;
    max-width: 80mm;
    margin: 20px auto;
    padding: 3mm;
    background: #fff;
    color: #000;
}

/* Receipt container */
.ticket {
    width: 100%;
}

/* Text alignment helpers */
.centered {
    text-align: center;
}

.left {
    text-align: left;
}

.right {
    text-align: right;
}

/* Store header */
.store-name {
    font-size: 16px;
    font-weight: bold;
    margin-bottom: 2px;
}

.store-info {
    font-size: 11px;
    margin-bottom: 1px;
}

/* Dividers */
.divider {
    border: none;
    border-top: 1px dashed #000;
    margin: 4px 0;
}

.divider-double {
    border: none;
    border-top: 2px solid #000;
    margin: 4px 0;
}

/* Info rows */
.info-row {
    display: flex;
    justify-content: space-between;
    margin: 1px 0;
}

.info-row .label {
    font-weight: normal;
}

.info-row .value {
    font-weight: normal;
    text-align: right;
}

/* Items table */
.items-table {
    width: 100%;
    border-collapse: collapse;
    margin: 4px 0;
}

.items-table th {
    text-align: left;
    font-weight: bold;
    font-size: 11px;
    border-bottom: 1px dashed #000;
    padding: 2px 0;
}

.items-table th:last-child {
    text-align: right;
}

.items-table td {
    padding: 2px 0;
    vertical-align: top;
    font-size: 11px;
}

.items-table td:last-child {
    text-align: right;
    white-space: nowrap;
}

.item-name {
    font-weight: bold;
}

.item-variant {
    font-size: 10px;
    color: #333;
}

.item-calc {
    font-size: 10px;
    color: #555;
}

/* Totals section */
.totals {
    margin: 4px 0;
}

.total-row {
    display: flex;
    justify-content: space-between;
    margin: 1px 0;
}

.total-row.grand {
    font-size: 14px;
    font-weight: bold;
    margin: 4px 0;
}

/* Footer */
.footer {
    margin-top: 6px;
    font-size: 11px;
}

.footer p {
    margin: 2px 0;
}

/* Print buttons - screen only */
.print-box {
    position: fixed;
    bottom: 20px;
    left: 50%;
    transform: translateX(-50%);
    background: #fff;
    padding: 15px 20px;
    border-radius: 12px;
    box-shadow: 0 4px 24px rgba(0,0,0,0.15);
    display: flex;
    gap: 12px;
    z-index: 1000;
}

.print-box button {
    padding: 12px 24px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    border: none;
    border-radius: 8px;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: all 0.2s;
}

.btn-print {
    background: linear-gradient(135deg, #2563eb, #1d4ed8);
    color: #fff;
}

.btn-print:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(37,99,235,0.4);
}

.btn-close {
    background: #f3f4f6;
    color: #374151;
}

.btn-close:hover {
    background: #e5e7eb;
}

/* Screen preview styling */
@media screen {
    body {
        background: #f5f5f5;
        padding-bottom: 100px;
    }
    .ticket {
        background: #fff;
        padding: 3mm;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
}
</style>
</head>
<body>

<div class="ticket" id="receipt">
    <!-- Store Header -->
    <div class="centered">
        <div class="store-name">{{ $settings->store_name ?? 'My Store' }}</div>
        @if($settings->store_address ?? '')
        <div class="store-info">{{ $settings->store_address }}</div>
        @endif
        @if($settings->store_phone ?? '')
        <div class="store-info">Tel: {{ $settings->store_phone }}</div>
        @endif
        @if($settings->store_gstin ?? '')
        <div class="store-info">GSTIN: {{ $settings->store_gstin }}</div>
        @endif
    </div>

    <hr class="divider-double">

    <!-- Invoice Info -->
    <div class="info-row">
        <span class="label">Invoice:</span>
        <span class="value">{{ $sale->invoice_no }}</span>
    </div>
    <div class="info-row">
        <span class="label">Date:</span>
        <span class="value">{{ $sale->created_at->format('d/m/Y h:i A') }}</span>
    </div>
    @if($sale->warehouse)
    <div class="info-row">
        <span class="label">Store:</span>
        <span class="value">{{ $sale->warehouse->name }}</span>
    </div>
    @endif
    @if($sale->user || $sale->customer_name)
    <div class="info-row">
        <span class="label">Customer:</span>
        <span class="value">{{ $sale->user?->name ?? $sale->customer_name }}</span>
    </div>
    @endif
    <div class="info-row">
        <span class="label">Cashier:</span>
        <span class="value">{{ $sale->admin->name ?? '-' }}</span>
    </div>

    <hr class="divider">

    <!-- Items -->
    <table class="items-table">
        <thead>
            <tr>
                <th>Item</th>
                <th>Qty</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sale->items as $item)
            <tr>
                <td>
                    <div class="item-name">{{ Str::limit($item->product_name, 20) }}</div>
                    @if($item->variant_name)
                    <div class="item-variant">{{ $item->variant_name }}</div>
                    @endif
                    <div class="item-calc">{{ $item->qty }} x ₹{{ number_format($item->price, 2) }}@if($item->tax_rate > 0) +{{ number_format($item->tax_rate, 0) }}%@endif</div>
                </td>
                <td>{{ $item->qty }}</td>
                <td>₹{{ number_format($item->line_total, 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <hr class="divider">

    <!-- Totals -->
    <div class="totals">
        <div class="total-row">
            <span>Subtotal:</span>
            <span>₹{{ number_format($sale->subtotal, 2) }}</span>
        </div>
        @if($sale->discount_amount > 0)
        <div class="total-row">
            <span>Discount:</span>
            <span>-₹{{ number_format($sale->discount_amount, 2) }}</span>
        </div>
        @endif
        @if($sale->tax_amount > 0)
        <div class="total-row">
            <span>Tax (GST):</span>
            <span>₹{{ number_format($sale->tax_amount, 2) }}</span>
        </div>
        @endif
    </div>

    <hr class="divider-double">

    <div class="total-row grand">
        <span>TOTAL:</span>
        <span>₹{{ number_format($sale->total, 2) }}</span>
    </div>

    <hr class="divider">

    <!-- Payment Info -->
    <div class="info-row">
        <span class="label">Payment:</span>
        <span class="value">{{ strtoupper($sale->payment_method) }}</span>
    </div>
    @if($sale->payment_method == 'cash')
    <div class="info-row">
        <span class="label">Received:</span>
        <span class="value">₹{{ number_format($sale->cash_received ?? $sale->total, 2) }}</span>
    </div>
    <div class="info-row">
        <span class="label">Change:</span>
        <span class="value">₹{{ number_format($sale->change_amount ?? 0, 2) }}</span>
    </div>
    @endif

    <hr class="divider">

    <!-- Footer -->
    <div class="footer centered">
        <p><strong>{{ $sale->invoice_no }}</strong></p>
        <p>{{ $settings->receipt_footer ?? 'Thank you for shopping!' }}</p>
        <p>{{ now()->format('d/m/Y h:i A') }}</p>
    </div>
</div>

<!-- Print Buttons (hidden during print) -->
<div class="print-box no-print">
    <button class="btn-print" onclick="window.print()">🖨️ Print Receipt</button>
    <button class="btn-close" onclick="window.close()">✕ Close</button>
</div>

<script>
// Auto-print on load
window.onload = function() {
    setTimeout(function() {
        window.print();
    }, 300);
};
</script>
</body>
</html>
