<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('project_statuses')) {
            Schema::create('project_statuses', function (Blueprint $table) {
                $table->id();
                $table->string('label', 100);
                $table->string('color', 20)->default('#3b82f6');
                $table->integer('sort_order')->default(0);
                $table->boolean('show_by_default')->default(true);
                $table->boolean('is_active')->default(true);
                
                $table->index('is_active');
            });

            // Insert default statuses
            DB::table('project_statuses')->insert([
                ['label' => 'Planned', 'color' => '#6b7280', 'sort_order' => 1, 'show_by_default' => true, 'is_active' => true],
                ['label' => 'Active', 'color' => '#3b82f6', 'sort_order' => 2, 'show_by_default' => true, 'is_active' => true],
                ['label' => 'On Hold', 'color' => '#f59e0b', 'sort_order' => 3, 'show_by_default' => false, 'is_active' => true],
                ['label' => 'Completed', 'color' => '#10b981', 'sort_order' => 4, 'show_by_default' => true, 'is_active' => true],
                ['label' => 'Cancelled', 'color' => '#ef4444', 'sort_order' => 5, 'show_by_default' => false, 'is_active' => true],
            ]);
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('project_statuses');
    }
};
