<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('task_statuses')) {
            Schema::create('task_statuses', function (Blueprint $table) {
                $table->id();
                $table->string('label', 100);
                $table->string('color', 20)->default('#3b82f6');
                $table->integer('sort_order')->default(0);
                $table->boolean('show_by_default')->default(true);
                $table->boolean('is_completed')->default(false);
                $table->boolean('is_active')->default(true);
                
                $table->index('is_active');
                $table->index('is_completed');
            });

            // Insert default statuses
            DB::table('task_statuses')->insert([
                ['label' => 'Backlog', 'color' => '#9ca3af', 'sort_order' => 1, 'show_by_default' => true, 'is_completed' => false, 'is_active' => true],
                ['label' => 'To Do', 'color' => '#6b7280', 'sort_order' => 2, 'show_by_default' => true, 'is_completed' => false, 'is_active' => true],
                ['label' => 'In Progress', 'color' => '#3b82f6', 'sort_order' => 3, 'show_by_default' => true, 'is_completed' => false, 'is_active' => true],
                ['label' => 'Review', 'color' => '#f59e0b', 'sort_order' => 4, 'show_by_default' => true, 'is_completed' => false, 'is_active' => true],
                ['label' => 'Done', 'color' => '#10b981', 'sort_order' => 5, 'show_by_default' => true, 'is_completed' => true, 'is_active' => true],
                ['label' => 'Blocked', 'color' => '#ef4444', 'sort_order' => 6, 'show_by_default' => false, 'is_completed' => false, 'is_active' => true],
            ]);
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('task_statuses');
    }
};
