<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('projects')) {
            Schema::create('projects', function (Blueprint $table) {
                $table->id();
                $table->string('title', 191);
                $table->unsignedBigInteger('account_id')->nullable();
                
                // Billing
                $table->enum('billing_method', ['fixed', 'project_hours', 'task_hours'])->default('fixed');
                $table->decimal('fixed_amount', 12, 2)->nullable();
                $table->decimal('hourly_rate', 12, 2)->nullable();
                $table->unsignedBigInteger('currency_id')->nullable();
                
                // Status and dates
                $table->unsignedBigInteger('status_id')->nullable();
                $table->date('planned_start_date')->nullable();
                $table->date('planned_end_date')->nullable();
                $table->date('actual_start_date')->nullable();
                $table->date('actual_end_date')->nullable();
                
                // Content
                $table->text('scope_notes')->nullable();
                $table->text('internal_notes')->nullable();
                
                // Flags
                $table->boolean('is_pinned')->default(false);
                $table->boolean('is_billable')->default(true);
                
                // Portal visibility controls
                $table->boolean('portal_show_tasks')->default(false);
                $table->boolean('portal_allow_task_comments')->default(false);
                $table->boolean('portal_show_task_conversations')->default(false);
                $table->boolean('portal_show_task_files')->default(false);
                $table->boolean('portal_show_checklist')->default(false);
                $table->boolean('portal_allow_task_uploads')->default(false);
                $table->boolean('portal_show_time_logs')->default(false);
                $table->boolean('portal_show_finance')->default(false);
                $table->boolean('portal_allow_file_uploads')->default(false);
                $table->boolean('portal_show_discussions')->default(false);
                $table->boolean('portal_show_milestones')->default(false);
                $table->boolean('portal_show_gantt')->default(false);
                $table->boolean('portal_show_activity')->default(false);
                $table->boolean('portal_show_team')->default(false);
                
                // Audit
                $table->unsignedBigInteger('created_by')->nullable();
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });

            // Add indexes separately
            Schema::table('projects', function (Blueprint $table) {
                $table->index('account_id');
                $table->index('status_id');
                $table->index('is_pinned');
                $table->index('is_billable');
                $table->index('created_by');
                $table->index(['status_id', 'is_pinned']);
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
