<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('project_milestones')) {
            Schema::create('project_milestones', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('project_id');
                $table->string('name', 191);
                $table->text('description')->nullable();
                $table->date('target_date')->nullable();
                $table->timestamp('completed_at')->nullable();
                $table->boolean('is_completed')->default(false);
                $table->boolean('portal_visible')->default(false);
                $table->integer('sort_order')->default(0);
                $table->unsignedBigInteger('created_by')->nullable();
                $table->timestamps();
            });

            // Add indexes separately
            Schema::table('project_milestones', function (Blueprint $table) {
                $table->index('project_id');
                $table->index('is_completed');
                $table->index(['project_id', 'sort_order']);
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('project_milestones');
    }
};
