<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('project_tasks')) {
            Schema::create('project_tasks', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('project_id');
                $table->unsignedBigInteger('milestone_id')->nullable();
                $table->string('title', 191);
                $table->text('description')->nullable();
                $table->unsignedBigInteger('status_id')->nullable();
                $table->enum('priority', ['low', 'medium', 'high', 'critical'])->default('medium');
                
                // Dates
                $table->date('planned_start_date')->nullable();
                $table->date('due_date')->nullable();
                $table->timestamp('completed_at')->nullable();
                
                // Billing
                $table->decimal('estimated_hours', 8, 2)->nullable();
                $table->decimal('hourly_rate', 12, 2)->nullable();
                $table->boolean('is_billable')->default(true);
                
                // Recurring
                $table->boolean('is_recurring')->default(false);
                $table->string('recurring_frequency', 50)->nullable();
                $table->date('recurring_until')->nullable();
                
                // Hierarchy
                $table->unsignedBigInteger('parent_task_id')->nullable();
                $table->integer('sort_order')->default(0);
                
                // Audit
                $table->unsignedBigInteger('created_by')->nullable();
                $table->unsignedBigInteger('updated_by')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });

            // Add indexes separately
            Schema::table('project_tasks', function (Blueprint $table) {
                $table->index('project_id');
                $table->index('milestone_id');
                $table->index('status_id');
                $table->index('priority');
                $table->index('due_date');
                $table->index('parent_task_id');
                $table->index('created_by');
                $table->index(['project_id', 'status_id']);
                $table->index(['project_id', 'milestone_id']);
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('project_tasks');
    }
};
