<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('project_discussions')) {
            Schema::create('project_discussions', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('project_id');
                $table->string('title', 191);
                $table->text('message');
                $table->boolean('portal_visible')->default(false);
                $table->unsignedBigInteger('created_by');
                $table->string('attachment_filename', 191)->nullable();  
                $table->string('attachment_path', 500)->nullable();      
                $table->timestamps();
            });

            Schema::table('project_discussions', function (Blueprint $table) {
                $table->index('project_id');
                $table->index('created_by');
                $table->index(['project_id', 'portal_visible']);
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('project_discussions');
    }
};
