<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Discussion Replies
        if (!Schema::hasTable('discussion_replies')) {
            Schema::create('discussion_replies', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('discussion_id');
                $table->text('message');
                $table->unsignedBigInteger('created_by');
                $table->timestamps();
            });

            Schema::table('discussion_replies', function (Blueprint $table) {
                $table->index('discussion_id');
                $table->index('created_by');
            });
        }

        // Task Comments
        if (!Schema::hasTable('task_comments')) {
            Schema::create('task_comments', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('task_id');
                $table->unsignedBigInteger('admin_id');
                $table->text('comment');
                $table->boolean('portal_visible')->default(false);
                $table->timestamps();
            });

            Schema::table('task_comments', function (Blueprint $table) {
                $table->index('task_id');
                $table->index('admin_id');
            });
        }

        // Task Attachments
        if (!Schema::hasTable('task_attachments')) {
            Schema::create('task_attachments', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('task_id');
                $table->string('filename', 191);
                $table->string('file_path', 500);
                $table->bigInteger('file_size')->nullable();
                $table->unsignedBigInteger('uploaded_by');
                $table->timestamp('created_at');
            });

            Schema::table('task_attachments', function (Blueprint $table) {
                $table->index('task_id');
                $table->index('uploaded_by');
            });
        }

        // Task Checklists
        if (!Schema::hasTable('task_checklists')) {
            Schema::create('task_checklists', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('task_id');
                $table->string('title', 191);
                $table->boolean('is_completed')->default(false);
                $table->integer('sort_order')->default(0);
                $table->timestamps();
            });

            Schema::table('task_checklists', function (Blueprint $table) {
                $table->index('task_id');
                $table->index(['task_id', 'sort_order']);
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('discussion_replies');
        Schema::dropIfExists('task_comments');
        Schema::dropIfExists('task_attachments');
        Schema::dropIfExists('task_checklists');
    }
};
