<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Project Team Members
        if (!Schema::hasTable('project_team')) {
            Schema::create('project_team', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('project_id');
                $table->unsignedBigInteger('admin_id');
                $table->timestamps();
            });

            Schema::table('project_team', function (Blueprint $table) {
                $table->unique(['project_id', 'admin_id']);
                $table->index('project_id');
                $table->index('admin_id');
            });
        }

        // Task Owners
        if (!Schema::hasTable('task_owners')) {
            Schema::create('task_owners', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('task_id');
                $table->unsignedBigInteger('admin_id');
                $table->timestamps();
            });

            Schema::table('task_owners', function (Blueprint $table) {
                $table->unique(['task_id', 'admin_id']);
                $table->index('task_id');
                $table->index('admin_id');
            });
        }

        // Task Followers
        if (!Schema::hasTable('task_followers')) {
            Schema::create('task_followers', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('task_id');
                $table->unsignedBigInteger('admin_id');
                $table->timestamps();
            });

            Schema::table('task_followers', function (Blueprint $table) {
                $table->unique(['task_id', 'admin_id']);
                $table->index('task_id');
                $table->index('admin_id');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('project_team');
        Schema::dropIfExists('task_owners');
        Schema::dropIfExists('task_followers');
    }
};
