<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('discussion_attachments')) {
            Schema::create('discussion_attachments', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('discussion_id');
                $table->string('file_name', 255);           // Original filename
                $table->string('file_path', 500);           // Storage path
                $table->string('file_type', 100)->nullable(); // MIME type
                $table->unsignedBigInteger('file_size')->default(0); // Size in bytes
                $table->unsignedBigInteger('uploaded_by')->nullable();
                $table->timestamps();

                $table->index('discussion_id');
                $table->index('uploaded_by');
                
                $table->foreign('discussion_id')
                    ->references('id')
                    ->on('project_discussions')
                    ->onDelete('cascade');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('discussion_attachments');
    }
};
