<?php

namespace Modules\ProjectManagement\Models;

use Illuminate\Database\Eloquent\Model;

class DiscussionReply extends Model
{
    protected $table = 'discussion_replies';

    protected $fillable = [
        'discussion_id',
        'message',
        'created_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function discussion()
    {
        return $this->belongsTo(Discussion::class, 'discussion_id');
    }

    public function creator()
    {
        return $this->belongsTo('App\Models\Admin', 'created_by');
    }
}
