<?php

namespace Modules\ProjectManagement\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class ProjectStatus extends Model
{
    protected $table = 'project_statuses';

    protected $fillable = [
        'label',
        'color',
        'sort_order',
        'show_by_default',
        'is_active',
    ];

    protected $casts = [
        'show_by_default' => 'boolean',
        'is_active' => 'boolean',
    ];

    public $timestamps = false;

    // ==================== RELATIONSHIPS ====================

    public function projects()
    {
        return $this->hasMany(Project::class, 'status_id');
    }

    // ==================== SCOPES ====================

    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true);
    }

    public function scopeDefault(Builder $query): Builder
    {
        return $query->where('show_by_default', true);
    }
}
