<?php

namespace Modules\ProjectManagement\Models;

use Illuminate\Database\Eloquent\Model;

class TaskChecklist extends Model
{
    protected $table = 'task_checklists';

    protected $fillable = [
        'task_id',
        'title',
        'is_completed',
        'sort_order',
    ];

    protected $casts = [
        'is_completed' => 'boolean',
        'sort_order' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // ==================== RELATIONSHIPS ====================

    public function task()
    {
        return $this->belongsTo(Task::class, 'task_id');
    }

    // ==================== SCOPES ====================

    public function scopeCompleted($query)
    {
        return $query->where('is_completed', true);
    }

    public function scopeIncomplete($query)
    {
        return $query->where('is_completed', false);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order', 'asc');
    }

    // ==================== METHODS ====================

    public function toggleCompleted(): bool
    {
        $this->is_completed = !$this->is_completed;
        return $this->save();
    }

    public function markAsCompleted(): bool
    {
        $this->is_completed = true;
        return $this->save();
    }

    public function markAsIncomplete(): bool
    {
        $this->is_completed = false;
        return $this->save();
    }

    // ==================== ACCESSORS ====================

    public function getStatusLabelAttribute(): string
    {
        return $this->is_completed ? 'Completed' : 'Pending';
    }

    public function getStatusColorAttribute(): string
    {
        return $this->is_completed ? '#10b981' : '#9ca3af';
    }
}
