# Project Management Module for EchoPx Laravel

**Version:** 1.0.0  
**Author:** EchoPx Technologies

## Overview

Complete project management solution with tasks, time tracking, milestones, billing integration, and client portal capabilities.

## Features

### Core Functionality
- **Project Management**: Complete CRUD operations, status tracking, pin/unpin, duplicate projects
- **Task Management**: Multiple owners, followers, comments, file attachments, recurring tasks, checklists
- **Time Tracking**: Live timers, manual time entries, billable/non-billable tracking
- **Milestones**: Project phase management with progress tracking
- **Discussions**: Project-level threaded discussions with portal visibility
- **Billing Integration**: Three billing methods (fixed amount, project hours, task hours)
- **Finance View**: Comprehensive billing and time tracking overview
- **Portal Controls**: Granular per-project visibility controls for client portal

### Billing Methods
1. **Fixed Amount**: Set project budget, track against fixed price
2. **Project Hours**: Bill all project time at project hourly rate
3. **Task Hours**: Bill each task at its own hourly rate

### Portal Visibility Controls
Each project can independently control what clients see:
- Tasks visibility and commenting
- Time logs and finance summaries
- File uploads and attachments
- Milestones and checkpoints
- Discussion threads
- Activity feed and team list
- Gantt charts (where enabled)

## Installation Instructions

### Method 1: Admin Panel Upload (Recommended)

1. **Download the Module**
   - Download `ProjectManagement.zip`

2. **Upload via Admin Panel**
   - Login to your admin panel
   - Navigate to Modules section
   - Click "Upload Module"
   - Select `ProjectManagement.zip`
   - Click "Install"

3. **Enable the Module**
   - After upload, click "Enable" on the ProjectManagement module
   - The system will automatically run migrations

4. **Clear Caches**
   ```bash
   php artisan route:clear
   php artisan config:clear
   php artisan view:clear
   ```

5. **Verify Installation**
   - Refresh admin panel
   - You should see "Projects" in the sidebar menu
   - Navigate to Projects to verify everything works

### Method 2: Manual Installation

1. **Extract Files**
   ```bash
   unzip ProjectManagement.zip -d /path/to/your/app/Modules/
   ```

2. **Run Migrations**
   ```bash
   cd /path/to/your/app
   php artisan migrate
   ```

3. **Enable Module**
   ```bash
   php artisan module:enable ProjectManagement
   ```

4. **Clear Caches**
   ```bash
   php artisan route:clear
   php artisan config:clear
   php artisan view:clear
   php artisan optimize:clear
   ```

5. **Verify Installation**
   ```bash
   php artisan module:list
   # Should show ProjectManagement as enabled
   
   php artisan route:list | grep projects
   # Should show all project routes
   ```

## Database Tables Created

The module creates the following tables (safely checks for existence first):

### Core Tables
- `project_statuses` - Project status definitions
- `task_statuses` - Task status definitions
- `projects` - Main projects table
- `project_milestones` - Project milestones/checkpoints
- `project_tasks` - Tasks linked to projects
- `project_time_logs` - Time tracking entries
- `project_discussions` - Project discussion threads

### Support Tables
- `discussion_replies` - Replies to discussions
- `task_comments` - Task comments
- `task_attachments` - File attachments on tasks
- `task_checklists` - Task checklist items

### Relationship Tables
- `project_team` - Project team members (many-to-many)
- `task_owners` - Task owners (many-to-many)
- `task_followers` - Task followers (many-to-many)

## Configuration

### Module Configuration
Edit `Modules/ProjectManagement/Config/config.php` to customize:

```php
return [
    'per_page' => 15, // Default pagination
    
    'billing_methods' => [
        'fixed' => 'Fixed Amount',
        'project_hours' => 'Project Hours',
        'task_hours' => 'Task Hours',
    ],
    
    'priorities' => [
        'low' => 'Low',
        'medium' => 'Medium',
        'high' => 'High',
        'critical' => 'Critical',
    ],
    
    'timer' => [
        'auto_stop_hours' => 12, // Auto-stop timers after X hours
        'round_minutes' => 15, // Round time entries to nearest X minutes
    ],
];
```

### Default Statuses

**Project Statuses:**
- Planned (Gray)
- Active (Blue)
- On Hold (Orange)
- Completed (Green)
- Cancelled (Red)

**Task Statuses:**
- Backlog (Gray)
- To Do (Dark Gray)
- In Progress (Blue)
- Review (Orange)
- Done (Green) - Marks task as completed
- Blocked (Red)

## Usage Guide

### Creating a Project

1. Navigate to **Projects** > **Add Project**
2. Fill in required fields:
   - Title
   - Account (customer)
   - Billing Method
   - Status
   - Planned dates
3. Set Portal Visibility controls (what customer can see)
4. Add Team Members
5. Click **Create**

### Managing Tasks

1. Open a project
2. Click **Add Task** or navigate to **Tasks** menu
3. Set:
   - Title and description
   - Status and priority
   - Owners and followers
   - Due date
   - Milestone (optional)
   - Hourly rate (for task-hours billing)
4. Add comments, attachments, and checklist items as needed

### Time Tracking

**Using Timers:**
1. Open a task
2. Click **Start Timer**
3. Work on the task
4. Click **Stop Timer** when done
5. Timer automatically calculates duration

**Manual Entry:**
1. Navigate to **Time Logs** > **Add Entry**
2. Select task
3. Enter start/end time or duration
4. Mark as billable/non-billable
5. Save

### Creating Milestones

1. Open a project
2. Navigate to **Milestones** tab
3. Click **Add Milestone**
4. Enter name, description, target date
5. Link tasks to milestone

### Project Discussions

1. Open a project
2. Navigate to **Discussions** tab
3. Click **New Discussion**
4. Enter title and message
5. Toggle portal visibility if clients should see it
6. Post

### Billing and Finance

1. Open a project
2. Navigate to **Finance** tab
3. Review:
   - Total hours logged
   - Billable vs non-billable hours
   - Billed vs unbilled work
   - Dollar amounts
4. Select unbilled items
5. Click **Generate Invoice** (integrates with Invoice module)

### Portal Visibility

Configure what clients see per project:

**In Project Edit:**
1. Scroll to **Portal Settings** section
2. Toggle switches for:
   - Show Tasks
   - Allow Task Comments
   - Show Time Logs
   - Show Finance Summary
   - Show Discussions
   - Show Milestones
   - Show Team List
   - Show Activity Feed
3. Save project

## Routes

All routes are prefixed with `admin/` and require admin authentication:

### Projects
- `GET /admin/projects` - List projects
- `GET /admin/projects/data` - DataTable AJAX endpoint
- `GET /admin/projects/create` - Create form
- `POST /admin/projects` - Store new project
- `GET /admin/projects/{id}` - View project
- `GET /admin/projects/{id}/edit` - Edit form
- `PUT /admin/projects/{id}` - Update project
- `DELETE /admin/projects/{id}` - Delete project
- `POST /admin/projects/{id}/pin` - Pin/unpin project
- `POST /admin/projects/{id}/duplicate` - Duplicate project
- `GET /admin/projects/{id}/finance` - Finance overview
- `POST /admin/projects/{id}/generate-invoice` - Generate invoice

### Tasks
- `GET /admin/tasks` - List tasks
- `GET /admin/tasks/data` - DataTable AJAX endpoint
- `GET /admin/tasks/create` - Create form
- `POST /admin/tasks` - Store new task
- `GET /admin/tasks/{id}` - View task
- `GET /admin/tasks/{id}/edit` - Edit form
- `PUT /admin/tasks/{id}` - Update task
- `DELETE /admin/tasks/{id}` - Delete task
- `POST /admin/tasks/{id}/start-timer` - Start timer
- `POST /admin/tasks/{id}/stop-timer` - Stop timer
- `POST /admin/tasks/{id}/comment` - Add comment
- `POST /admin/tasks/{id}/attach` - Upload attachment

### Time Logs
- `GET /admin/timelogs` - List time logs
- `GET /admin/timelogs/data` - DataTable AJAX endpoint
- `GET /admin/timelogs/create` - Create manual entry
- `POST /admin/timelogs` - Store entry
- `PUT /admin/timelogs/{id}` - Update entry
- `DELETE /admin/timelogs/{id}` - Delete entry

### Milestones
- `GET /admin/milestones` - List milestones
- `GET /admin/milestones/data` - DataTable AJAX endpoint
- `GET /admin/milestones/create` - Create form
- `POST /admin/milestones` - Store milestone
- `PUT /admin/milestones/{id}` - Update milestone
- `DELETE /admin/milestones/{id}` - Delete milestone

### Discussions
- `GET /admin/discussions` - List discussions
- `GET /admin/discussions/data` - DataTable AJAX endpoint
- `GET /admin/discussions/create` - Create form
- `POST /admin/discussions` - Store discussion
- `GET /admin/discussions/{id}` - View discussion
- `DELETE /admin/discussions/{id}` - Delete discussion
- `POST /admin/discussions/{id}/reply` - Add reply

## Permissions

The module uses the `EnsureIsAdmin` middleware. To implement role-based permissions:

1. Use AdminController's permission methods:
   ```php
   $this->authorizePermission('view_projects');
   $this->authorizePermission('edit_projects');
   ```

2. Check in views:
   ```php
   @if($admin->hasPermissionTo('create_projects'))
       <a href="{{ route('admin.projects.create') }}">Add Project</a>
   @endif
   ```

## Troubleshooting

### Module Not Showing
1. Check module is enabled: `php artisan module:list`
2. Enable if needed: `php artisan module:enable ProjectManagement`
3. Clear caches: `php artisan optimize:clear`

### Routes Not Working
```bash
php artisan route:clear
php artisan route:list | grep projects
```

### Migrations Failed
If tables already exist, the migrations will skip them safely. If you need to re-run:
```bash
php artisan migrate:rollback --step=1
php artisan migrate
```

### Views Not Found
```bash
php artisan view:clear
php artisan config:clear
```

### Menu Not Showing
Check `Modules/ProjectManagement/Resources/views/menu.blade.php` exists and is properly formatted.

## Module Structure

```
ProjectManagement/
├── Config/
│   └── config.php
├── Database/
│   └── Migrations/
│       ├── 2024_01_01_000001_create_project_statuses_table.php
│       ├── 2024_01_01_000002_create_task_statuses_table.php
│       ├── 2024_01_01_000003_create_projects_table.php
│       ├── 2024_01_01_000004_create_project_milestones_table.php
│       ├── 2024_01_01_000005_create_project_tasks_table.php
│       ├── 2024_01_01_000006_create_project_time_logs_table.php
│       ├── 2024_01_01_000007_create_project_discussions_table.php
│       ├── 2024_01_01_000008_create_support_tables.php
│       └── 2024_01_01_000009_create_pivot_tables.php
├── Http/
│   └── Controllers/
│       ├── ProjectController.php
│       ├── TaskController.php
│       ├── TimeLogController.php
│       ├── MilestoneController.php
│       └── DiscussionController.php
├── Models/
│   ├── Project.php
│   ├── Task.php
│   ├── TimeLog.php
│   ├── Milestone.php
│   ├── Discussion.php
│   ├── ProjectStatus.php
│   ├── TaskStatus.php
│   └── SupportModels.php (TaskComment, TaskAttachment, etc.)
├── Providers/
│   ├── ProjectManagementServiceProvider.php
│   └── RouteServiceProvider.php
├── Resources/
│   └── views/
│       ├── projects/ (index, create, edit, show, finance)
│       ├── tasks/ (index, create, edit, show)
│       ├── timelogs/ (index, create, edit)
│       ├── milestones/ (index, create, edit)
│       ├── discussions/ (index, create, show)
│       └── menu.blade.php
├── Routes/
│   └── web.php
├── module.json
├── composer.json
└── README.md
```

## Support

For issues or questions:
- Check this README first
- Review the EchoPx Module Development Guide
- Verify all caches are cleared
- Check Laravel logs: `storage/logs/laravel.log`

## Version History

### 1.0.0 (Current)
- Initial release
- Complete project management functionality
- Task management with time tracking
- Milestone management
- Project discussions
- Billing integration ready
- Portal visibility controls
- Safe migrations that check for existing tables

## License

Proprietary - EchoPx Technologies

---

**Module Name:** ProjectManagement  
**Alias:** projectmanagement  
**Version:** 1.0.0  
**Last Updated:** December 2024
