# Views Implementation Guide

## Created Views

### Projects
- `projects/index.blade.php` - Projects list with DataTable (COMPLETE)
- Additional views needed: create.blade.php, edit.blade.php, show.blade.php, finance.blade.php

### Tasks
- Views needed: index.blade.php, create.blade.php, edit.blade.php, show.blade.php

### Time Logs
- Views needed: index.blade.php, create.blade.php, edit.blade.php

### Milestones
- Views needed: index.blade.php, create.blade.php, edit.blade.php

### Discussions
- Views needed: index.blade.php, create.blade.php, show.blade.php

## View Structure Pattern

All views follow the EchoPx pattern - NO @extends needed!
Layout is automatically applied by moduleView() in the controller.

### Standard Form View Structure:
```blade
<style>
.form-page { max-width: 700px; margin: 0 auto; padding: 20px; }
.form-header { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; }
.btn-back { width: 40px; height: 40px; /* ... */ }
.form-card { background: var(--card-bg); border-radius: 16px; }
.form-group { margin-bottom: 20px; }
.form-input { width: 100%; padding: 12px 16px; border-radius: 10px; }
</style>

<div class="form-page">
    <div class="form-header">
        <a href="{{ route('admin.projects.index') }}" class="btn-back">←</a>
        <h1>Create Project</h1>
    </div>

    @if($errors->any())
        <div class="alert-errors">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </div>
    @endif

    <form action="{{ route('admin.projects.store') }}" method="POST">
        @csrf
        <div class="form-card">
            <div class="form-card-body">
                <!-- Form fields here -->
            </div>
            <div class="form-actions">
                <button type="submit" class="btn-submit">Create</button>
                <a href="{{ route('admin.projects.index') }}" class="btn-cancel">Cancel</a>
            </div>
        </div>
    </form>
</div>
```

### Available CSS Variables:
- var(--card-bg) - Card backgrounds
- var(--card-border) - Card borders
- var(--body-bg) - Page background
- var(--text-primary) - Main text
- var(--text-secondary) - Secondary text
- var(--text-muted) - Muted text
- var(--primary) - Primary color
- var(--primary-hover) - Primary hover
- var(--success) - Success/green
- var(--danger) - Error/red
- var(--warning) - Warning/orange
- var(--input-bg) - Input background
- var(--input-border) - Input border

## To Complete Views:

1. Copy the index.blade.php pattern for other list pages
2. Use the form structure above for create/edit pages
3. For show pages, use card-based layout similar to index
4. Always include proper validation error display
5. Use route() helper for all URLs
6. Use old() helper for form values
7. Include DataTable script with @include('core::datatable') on list pages

## Form Fields Reference:

### Project Form Fields:
- title (text, required)
- account_id (select, nullable)
- billing_method (select, required): fixed, project_hours, task_hours
- fixed_amount (number, nullable)
- hourly_rate (number, nullable)
- currency_id (select, nullable)
- status_id (select, required)
- planned_start_date (date, nullable)
- planned_end_date (date, nullable)
- scope_notes (textarea, nullable)
- internal_notes (textarea, nullable)
- is_billable (checkbox, default true)
- team[] (multi-select, array of admin IDs)
- Portal visibility flags (15 boolean fields)

### Task Form Fields:
- project_id (select, required)
- milestone_id (select, nullable)
- title (text, required)
- description (textarea, nullable)
- status_id (select, required)
- priority (select, required): low, medium, high, critical
- planned_start_date (date, nullable)
- due_date (date, nullable)
- estimated_hours (number, nullable)
- hourly_rate (number, nullable)
- is_billable (checkbox, default true)
- owners[] (multi-select, admin IDs)
- followers[] (multi-select, admin IDs)

### Time Log Form Fields:
- task_id (select, required)
- admin_id (select, required - usually current user)
- start_time (datetime, required)
- end_time (datetime, nullable for running timers)
- description (textarea, nullable)
- is_billable (checkbox, default true)

### Milestone Form Fields:
- project_id (select, required)
- name (text, required)
- description (textarea, nullable)
- target_date (date, nullable)
- portal_visible (checkbox, default false)

### Discussion Form Fields:
- project_id (select, required)
- title (text, required)
- message (textarea, required)
- portal_visible (checkbox, default false)
