<style>
/* ========================================
   Discussions - Theme-Aware (GUIDE COMPLIANT)
   ======================================== */

/* Page Animation */
.discussions-page {
    padding: var(--space-xl);
    animation: fadeIn 0.4s ease;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Slide In Animation */
@keyframes slideIn {
    from { opacity: 0; transform: translateX(-20px); }
    to { opacity: 1; transform: translateX(0); }
}

/* Pulse Animation */
@keyframes pulse {
    0%, 100% { transform: scale(1); opacity: 1; }
    50% { transform: scale(1.05); opacity: 0.8; }
}

/* ===== PAGE HEADER ===== */
.page-header {
    background: var(--primary);
    padding: var(--space-lg) var(--space-xl);
    border-radius: var(--radius-lg);
    margin-bottom: var(--space-lg);
    box-shadow: var(--shadow-md);
    transition: all 0.3s ease;
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: var(--space-lg);
}

.header-left h1 {
    color: white;
    font-size: var(--font-xl);
    font-weight: 700;
    margin: 0 0 4px 0;
    display: flex;
    align-items: center;
    gap: var(--space-sm);
    letter-spacing: -0.02em;
}

.header-left h1 svg {
    width: 20px;
    height: 20px;
}

.header-left p {
    color: rgba(255, 255, 255, 0.9);
    font-size: var(--font-sm);
    margin: 0;
}

/* Search Bar */
.header-search {
    flex: 1;
    max-width: 320px;
    position: relative;
}

.header-search svg {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    width: 14px;
    height: 14px;
    color: rgba(255, 255, 255, 0.7);
    pointer-events: none;
    transition: all 0.3s ease;
}

.header-search input {
    width: 100%;
    padding: 8px 12px 8px 32px;
    border-radius: var(--radius-md);
    border: 1px solid rgba(255, 255, 255, 0.3);
    font-size: var(--font-sm);
    background: rgba(255, 255, 255, 0.15);
    color: white;
    transition: all 0.3s ease;
}

.header-search input::placeholder {
    color: rgba(255, 255, 255, 0.7);
}

.header-search input:focus {
    outline: none;
    background: white;
    color: #1a202c !important;
    border-color: white;
}

.header-search input:focus + svg {
    color: var(--primary);
}

/* Header Button */
.btn-primary {
    padding: 8px 16px;
    background: white;
    color: var(--primary);
    border: none;
    border-radius: var(--radius-md);
    font-size: var(--font-sm);
    font-weight: 600;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 6px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-primary svg {
    width: 14px;
    height: 14px;
}

/* ===== STATS CARDS ===== */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: var(--space-md);
    margin-bottom: var(--space-lg);
}

.stat-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-lg);
    padding: var(--space-md) var(--space-lg);
    display: flex;
    align-items: center;
    gap: var(--space-md);
    transition: all 0.3s ease;
    animation: slideIn 0.3s ease;
}

.stat-card:nth-child(1) { animation-delay: 0.1s; }
.stat-card:nth-child(2) { animation-delay: 0.2s; }
.stat-card:nth-child(3) { animation-delay: 0.3s; }

.stat-card:hover {
    transform: translateY(-2px) scale(1.02);
    box-shadow: var(--shadow-md);
}

.stat-icon {
    width: 36px;
    height: 36px;
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    transition: all 0.3s ease;
}

.stat-card:hover .stat-icon {
    animation: pulse 1s ease infinite;
}

.stat-icon svg {
    width: 18px;
    height: 18px;
    color: white;
}

.stat-icon-primary { background: var(--primary); }
.stat-icon-success { background: var(--success); }
.stat-icon-warning { background: var(--warning); }

.stat-content h3 {
    font-size: var(--font-xl);
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    transition: all 0.3s ease;
}

.stat-card:hover .stat-content h3 {
    transform: scale(1.05);
}

.stat-content p {
    font-size: var(--font-xs);
    color: var(--text-muted);
    margin: 2px 0 0 0;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    font-weight: 600;
}

/* ===== FILTERS BAR ===== */
.filters-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    padding: var(--space-lg);
    border-radius: var(--radius-lg);
    margin-bottom: var(--space-lg);
    box-shadow: var(--shadow-sm);
    animation: fadeIn 0.4s ease 0.5s backwards;
}

.filters-row {
    display: flex;
    gap: var(--space-md);
    align-items: center;
    flex-wrap: wrap;
}

.quick-filters {
    display: flex;
    gap: var(--space-sm);
}

.filter-btn {
    padding: 8px 14px;
    border: 1px solid var(--card-border);
    background: var(--card-bg);
    color: var(--text-secondary);
    border-radius: var(--radius-md);
    font-size: var(--font-sm);
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
}

.filter-btn:hover {
    border-color: var(--primary);
    color: var(--primary);
    transform: translateY(-1px);
}

.filter-btn.active {
    background: var(--primary);
    color: white;
    border-color: var(--primary);
    box-shadow: var(--shadow-sm);
}

.per-page {
    display: flex;
    align-items: center;
    gap: var(--space-sm);
    margin-left: auto;
}

.per-page label {
    font-size: var(--font-sm);
    color: var(--text-secondary);
    font-weight: 600;
}

.per-page select {
    padding: 8px 12px;
    border: 1px solid var(--input-border);
    background: var(--input-bg);
    color: var(--input-text);
    border-radius: var(--radius-md);
    font-size: var(--font-sm);
    cursor: pointer;
    transition: all 0.3s ease;
}

/* ===== TABLE CARD ===== */
.table-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-lg);
    padding: var(--space-xl);
    box-shadow: var(--shadow-sm);
    animation: fadeIn 0.4s ease 0.6s backwards;
}

.table-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: var(--space-lg);
    padding-bottom: var(--space-md);
    border-bottom: 1px solid var(--card-border);
}

.table-title {
    font-size: var(--font-lg);
    font-weight: 700;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    gap: var(--space-sm);
}

.table-title svg {
    width: 18px;
    height: 18px;
    color: var(--primary);
}

.pagination-info {
    font-size: var(--font-sm);
    color: var(--text-muted);
    font-weight: 600;
}

/* ===== DATA TABLE ===== */
.data-table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
}

.data-table thead th {
    background: var(--input-bg);
    padding: 12px var(--space-md);
    text-align: left;
    font-size: var(--font-sm);
    font-weight: 600;
    color: var(--text-secondary);
    border-bottom: 2px solid var(--card-border);
    white-space: nowrap;
    cursor: pointer;
    transition: all 0.3s ease;
}

.data-table thead th:hover {
    background: var(--card-bg);
    color: var(--primary);
}

.data-table thead th.sortable::after {
    content: '⇅';
    margin-left: 4px;
    opacity: 0.3;
    font-size: 10px;
}

.data-table thead th.sorting-asc::after {
    content: '↑';
    opacity: 1;
    color: var(--primary);
}

.data-table thead th.sorting-desc::after {
    content: '↓';
    opacity: 1;
    color: var(--primary);
}

.data-table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid var(--card-border);
    animation: fadeIn 0.3s ease;
}

.data-table tbody tr:hover {
    background: var(--input-bg);
    transform: scale(1.005);
}

.data-table tbody td {
    padding: 14px var(--space-md);
    font-size: var(--font-base);
    color: var(--text-primary);
}

/* ===== BADGES ===== */
.badge {
    padding: 4px 10px;
    border-radius: 12px;
    font-size: var(--font-xs);
    font-weight: 600;
    text-transform: uppercase;
    display: inline-flex;
    align-items: center;
    gap: 4px;
    transition: all 0.3s ease;
}

.badge:hover {
    transform: scale(1.05);
}

.badge svg {
    width: 12px;
    height: 12px;
}

.badge-success {
    background: var(--success-light);
    color: var(--success);
}

.badge-danger {
    background: var(--danger-light);
    color: var(--danger);
}

/* ===== ACTION BUTTONS ===== */
.actions {
    display: flex;
    gap: 4px;
}

.btn-icon {
    width: 30px;
    height: 30px;
    border: none;
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-icon svg {
    width: 14px;
    height: 14px;
}

.btn-icon:hover {
    transform: translateY(-1px) scale(1.1);
}

.btn-view {
    background: var(--primary-light);
    color: var(--primary);
}

.btn-view:hover {
    background: var(--primary);
    color: white;
}

.btn-delete {
    background: var(--danger-light);
    color: var(--danger);
}

.btn-delete:hover {
    background: var(--danger);
    color: white;
}

/* ===== PAGINATION ===== */
.pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: var(--space-sm);
    margin-top: var(--space-xl);
    padding-top: var(--space-lg);
    border-top: 1px solid var(--card-border);
}

.page-btn {
    padding: 8px 14px;
    border: 1px solid var(--card-border);
    background: var(--card-bg);
    color: var(--text-secondary);
    border-radius: var(--radius-md);
    font-size: var(--font-sm);
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
}

.page-btn:hover:not(:disabled) {
    border-color: var(--primary);
    color: var(--primary);
    transform: translateY(-1px);
}

.page-btn:disabled {
    opacity: 0.4;
    cursor: not-allowed;
}

.page-btn.active {
    background: var(--primary);
    color: white;
    border-color: var(--primary);
    box-shadow: var(--shadow-sm);
}

/* ===== EMPTY STATE ===== */
.empty-state {
    text-align: center;
    padding: 64px 20px;
    animation: fadeIn 0.4s ease;
}

.empty-state svg {
    width: 64px;
    height: 64px;
    color: var(--text-muted);
    margin-bottom: 16px;
    animation: pulse 2s ease infinite;
}

.empty-state h3 {
    font-size: var(--font-lg);
    color: var(--text-secondary);
    margin-bottom: 8px;
    font-weight: 600;
}

/* ===== LOADING ===== */
.loading-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    z-index: 9999;
    align-items: center;
    justify-content: center;
}

.loading-overlay.active {
    display: flex;
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

.spinner {
    width: 40px;
    height: 40px;
    border: 4px solid var(--card-bg);
    border-top: 4px solid var(--primary);
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

/* ===== RESPONSIVE ===== */
@media (max-width: 992px) {
    .header-content {
        flex-direction: column;
        align-items: stretch;
    }
    
    .header-search {
        max-width: 100%;
    }
    
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .discussions-page {
        padding: var(--space-md);
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="discussions-page">
    <!-- Page Header -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-left">
                <h1>
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                    </svg>
                    Discussions
                </h1>
                <p>Project discussions and updates</p>
            </div>
            
            <div class="header-search">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <input type="text" id="searchInput" placeholder="Search discussions...">
            </div>
            
            <a href="{{ route('admin.discussions.create') }}" class="btn-primary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                </svg>
                New Discussion
            </a>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon stat-icon-primary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                </svg>
            </div>
            <div class="stat-content">
                <h3 id="totalDiscussions">{{ number_format($stats['total']) }}</h3>
                <p>Total Discussions</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon stat-icon-success">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                </svg>
            </div>
            <div class="stat-content">
                <h3 id="portalVisible">{{ number_format($stats['portal_visible']) }}</h3>
                <p>Portal Visible</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon stat-icon-primary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
            </div>
            <div class="stat-content">
                <h3 id="myDiscussions">{{ number_format($stats['my_discussions']) }}</h3>
                <p>My Discussions</p>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="filters-card">
        <div class="filters-row">
            <div class="quick-filters">
                <button class="filter-btn active" data-filter="all" onclick="applyFilter(this, 'all')">All</button>
                <button class="filter-btn" data-filter="portal_visible" onclick="applyFilter(this, 'portal_visible')">Portal Visible</button>
                <button class="filter-btn" data-filter="my_discussions" onclick="applyFilter(this, 'my_discussions')">My Discussions</button>
            </div>

            <div class="per-page">
                <label>Show:</label>
                <select id="perPageSelect" onchange="changePerPage(this.value)">
                    <option value="15" selected>15</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
        </div>
    </div>

    <!-- Discussions Table -->
    <div class="table-card">
        <div class="table-header">
            <h3 class="table-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                </svg>
                All Discussions
            </h3>
            <div class="pagination-info" id="paginationInfo">Showing 0-0 of 0 discussions</div>
        </div>

        <table class="data-table">
            <thead>
                <tr>
                    <th style="width: 40px;">
                        <input type="checkbox" id="selectAll" onchange="toggleSelectAll(this)">
                    </th>
                    <th class="sortable" data-column="id">ID</th>
                    <th class="sortable" data-column="title">Title</th>
                    <th class="sortable" data-column="project_id">Project</th>
                    <th class="sortable" data-column="created_by">Created By</th>
                    <th class="sortable" data-column="portal_visible">Portal</th>
                    <th>Replies</th>
                    <th class="sortable" data-column="created_at">Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody id="discussionsBody">
                <!-- Populated via AJAX -->
            </tbody>
        </table>

        <!-- Pagination -->
        <div class="pagination" id="pagination" style="display: none;">
            <!-- Populated dynamically -->
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay" id="loadingOverlay">
    <div class="spinner"></div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
let currentPage = 1;
let perPage = 15;
let totalRecords = 0;
let lastPage = 1;
let sortColumn = 'created_at';
let sortDirection = 'desc';
let selectedIds = [];
let currentFilter = 'all';

$(document).ready(function() {
    loadDiscussions();

    // Search with debounce
    let searchTimeout;
    $('#searchInput').on('keyup', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => {
            currentPage = 1;
            loadDiscussions();
        }, 500);
    });

    // Column sorting
    $('.sortable').on('click', function() {
        const column = $(this).data('column');
        
        if (sortColumn === column) {
            sortDirection = sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            sortColumn = column;
            sortDirection = 'asc';
        }

        $('.sortable').removeClass('sorting-asc sorting-desc');
        $(this).addClass('sorting-' + sortDirection);

        loadDiscussions();
    });
});

function loadDiscussions() {
    showLoading();

    const filters = {
        search: $('#searchInput').val(),
        filter_type: currentFilter,
        page: currentPage,
        per_page: perPage,
        sort: sortColumn,
        dir: sortDirection
    };

    $.ajax({
        url: '{{ route("admin.discussions.data") }}',
        type: 'GET',
        data: filters,
        success: function(response) {
            renderDiscussions(response.data);
            updatePagination(response);
            hideLoading();
        },
        error: function(xhr) {
            hideLoading();
            alert('Error: ' + (xhr.responseJSON?.message || 'Unknown error'));
        }
    });
}

function renderDiscussions(discussions) {
    const tbody = $('#discussionsBody');
    tbody.empty();

    if (discussions.length === 0) {
        tbody.append(`
            <tr>
                <td colspan="9">
                    <div class="empty-state">
                        <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                        </svg>
                        <h3>No Discussions Found</h3>
                        <p>No discussions match your criteria</p>
                    </div>
                </td>
            </tr>
        `);
        return;
    }

    discussions.forEach(discussion => {
        // Portal badge
        const portalBadge = discussion.portal_visible
            ? `<span class="badge badge-success">
                <svg fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                </svg>
                Visible
            </span>`
            : `<span class="badge badge-danger">
                <svg fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                </svg>
                Hidden
            </span>`;

        const row = `
            <tr>
                <td><input type="checkbox" class="discussion-checkbox" value="${discussion.id}" onchange="toggleSelection(this)"></td>
                <td><strong>#${discussion.id}</strong></td>
                <td><strong>${discussion.title}</strong></td>
                <td>${discussion.project_display}</td>
                <td>${discussion.creator_display}</td>
                <td>${portalBadge}</td>
                <td>${discussion.replies_count || 0}</td>
                <td>${discussion.created_at_display}</td>
                <td>
                    <div class="actions">
                        <a href="${discussion._show_url}" class="btn-icon btn-view" title="View">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                            </svg>
                        </a>
                        <button class="btn-icon btn-delete" onclick="deleteDiscussion(${discussion.id})" title="Delete">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                            </svg>
                        </button>
                    </div>
                </td>
            </tr>
        `;
        tbody.append(row);
    });
}

function updatePagination(response) {
    totalRecords = response.total || 0;
    currentPage = response.current_page || 1;
    lastPage = response.last_page || 1;

    const startRecord = totalRecords === 0 ? 0 : ((currentPage - 1) * perPage) + 1;
    const endRecord = Math.min(currentPage * perPage, totalRecords);
    $('#paginationInfo').text(`Showing ${startRecord}-${endRecord} of ${totalRecords} discussions`);

    const pagination = $('#pagination');
    
    if (lastPage <= 1) {
        pagination.hide();
        return;
    }

    pagination.show().empty();

    // Previous button
    pagination.append(`
        <button class="page-btn" onclick="goToPage(${currentPage - 1})" ${currentPage === 1 ? 'disabled' : ''}>
            Previous
        </button>
    `);

    // Page numbers
    const maxPages = 7;
    let startPage = Math.max(1, currentPage - Math.floor(maxPages / 2));
    let endPage = Math.min(lastPage, startPage + maxPages - 1);

    if (endPage - startPage < maxPages - 1) {
        startPage = Math.max(1, endPage - maxPages + 1);
    }

    if (startPage > 1) {
        pagination.append(`<button class="page-btn" onclick="goToPage(1)">1</button>`);
        if (startPage > 2) pagination.append(`<span style="padding: 0 8px;">...</span>`);
    }

    for (let i = startPage; i <= endPage; i++) {
        pagination.append(`
            <button class="page-btn ${i === currentPage ? 'active' : ''}" onclick="goToPage(${i})">
                ${i}
            </button>
        `);
    }

    if (endPage < lastPage) {
        if (endPage < lastPage - 1) pagination.append(`<span style="padding: 0 8px;">...</span>`);
        pagination.append(`<button class="page-btn" onclick="goToPage(${lastPage})">${lastPage}</button>`);
    }

    // Next button
    pagination.append(`
        <button class="page-btn" onclick="goToPage(${currentPage + 1})" ${currentPage === lastPage ? 'disabled' : ''}>
            Next
        </button>
    `);
}

function goToPage(page) {
    if (page < 1 || page > lastPage) return;
    currentPage = page;
    loadDiscussions();
}

function changePerPage(value) {
    perPage = parseInt(value);
    currentPage = 1;
    loadDiscussions();
}

function applyFilter(button, type) {
    $('.filter-btn').removeClass('active');
    $(button).addClass('active');
    
    currentFilter = type;
    currentPage = 1;
    loadDiscussions();
}

function toggleSelection(checkbox) {
    const id = parseInt(checkbox.value);
    if (checkbox.checked) {
        selectedIds.push(id);
    } else {
        selectedIds = selectedIds.filter(item => item !== id);
    }
}

function toggleSelectAll(checkbox) {
    $('.discussion-checkbox').prop('checked', checkbox.checked);
    selectedIds = checkbox.checked ? 
        $('.discussion-checkbox').map(function() { return parseInt(this.value); }).get() : [];
}

function deleteDiscussion(discussionId) {
    if (!confirm('Delete this discussion?')) return;

    $.ajax({
        url: `/admin/discussions/${discussionId}`,
        type: 'DELETE',
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        success: function(response) {
            if (response.success) {
                alert(response.message);
                loadDiscussions();
                updateStats();
            }
        },
        error: function(xhr) {
            alert('Delete failed: ' + (xhr.responseJSON?.message || 'Error'));
        }
    });
}

function updateStats() {
    $.ajax({
        url: '{{ route("admin.discussions.stats") }}',
        type: 'GET',
        success: function(stats) {
            $('#totalDiscussions').text(stats.total.toLocaleString());
            $('#portalVisible').text(stats.portal_visible.toLocaleString());
            $('#myDiscussions').text(stats.my_discussions.toLocaleString());
        }
    });
}

function showLoading() {
    $('#loadingOverlay').addClass('active');
}

function hideLoading() {
    $('#loadingOverlay').removeClass('active');
}
</script>