<style>
/* ========== ANIMATIONS ========== */
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideIn {
    from { opacity: 0; transform: translateX(-10px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

/* ========== BASE LAYOUT ========== */
.discussion-view { 
    padding: 24px; 
    max-width: 1000px; 
    margin: 0 auto;
    animation: fadeInUp 0.5s ease;
    min-height: 100vh;
}

/* ========== HEADER ========== */
.discussion-header {
    display: flex;
    justify-content: space-between;
    align-items: start;
    margin-bottom: 28px;
    animation: slideIn 0.3s ease;
    gap: 20px;
}

.discussion-title-section { 
    display: flex; 
    align-items: start; 
    gap: 16px;
    flex: 1;
}

.discussion-title-content {
    flex: 1;
}

.discussion-title-content h1 {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 8px 0;
    letter-spacing: -0.02em;
    line-height: 1.2;
}

.project-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: var(--primary-light);
    border: 1px solid var(--primary);
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    color: var(--primary);
    text-decoration: none;
    transition: all 0.3s ease;
}

.project-badge.no-link {
    cursor: default;
}

.project-badge:not(.no-link):hover {
    background: var(--primary);
    color: white;
    transform: translateY(-2px);
}

.project-badge svg {
    width: 14px;
    height: 14px;
}

.btn-back {
    width: 42px; 
    height: 42px;
    display: flex; 
    align-items: center; 
    justify-content: center;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    text-decoration: none;
    color: var(--text-secondary);
    transition: all 0.3s ease;
    flex-shrink: 0;
}

.btn-back:hover {
    background: var(--primary);
    color: white;
    border-color: var(--primary);
    transform: translateX(-3px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

/* ========== DISCUSSION CARD ========== */
.discussion-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 16px;
    padding: 28px;
    margin-bottom: 32px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    animation: fadeInUp 0.6s ease;
}

.discussion-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 16px;
    align-items: center;
    font-size: 14px;
    margin-bottom: 20px;
    padding-bottom: 20px;
    border-bottom: 1px solid var(--card-border);
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 6px;
    color: var(--text-secondary);
}

.meta-item svg {
    width: 16px;
    height: 16px;
    color: var(--text-muted);
}

.meta-item strong {
    color: var(--text-primary);
    font-weight: 600;
}

.meta-divider {
    width: 4px;
    height: 4px;
    background: var(--text-muted);
    border-radius: 50%;
}

.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 4px 10px;
    background: var(--success-light);
    border: 1px solid var(--success);
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    color: var(--success);
}

.status-badge svg {
    width: 14px;
    height: 14px;
}

.discussion-content {
    line-height: 1.7;
    white-space: pre-wrap;
    color: var(--text-primary);
    font-size: 15px;
}

/* ========== ATTACHMENTS SECTION ========== */
.attachments-section {
    margin-top: 24px;
    padding-top: 24px;
    border-top: 1px solid var(--card-border);
}

.attachments-header {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 16px;
}

.attachments-header svg {
    width: 20px;
    height: 20px;
    color: var(--text-muted);
}

.attachments-header h4 {
    font-size: 15px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.attachments-count {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 22px;
    height: 22px;
    padding: 0 6px;
    background: var(--primary-light);
    color: var(--primary);
    font-size: 12px;
    font-weight: 700;
    border-radius: 12px;
}

.attachments-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 12px;
}

.attachment-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 14px 16px;
    background: var(--body-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    transition: all 0.2s ease;
}

.attachment-item:hover {
    border-color: var(--primary);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.attachment-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: var(--primary-light);
    border-radius: 8px;
    color: var(--primary);
    flex-shrink: 0;
}

.attachment-icon svg {
    width: 20px;
    height: 20px;
}

.attachment-icon.image { background: var(--success-light); color: var(--success); }
.attachment-icon.document { background: var(--warning-light); color: var(--warning); }
.attachment-icon.archive { background: var(--info-light); color: var(--info); }

.attachment-thumbnail {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    object-fit: cover;
    flex-shrink: 0;
}

.attachment-info {
    flex: 1;
    min-width: 0;
}

.attachment-name {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    margin-bottom: 2px;
}

.attachment-size {
    font-size: 12px;
    color: var(--text-muted);
}

.attachment-actions {
    display: flex;
    gap: 6px;
}

.attachment-btn {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: transparent;
    border: 1px solid var(--card-border);
    border-radius: 6px;
    color: var(--text-secondary);
    cursor: pointer;
    transition: all 0.2s ease;
    text-decoration: none;
}

.attachment-btn:hover {
    background: var(--primary);
    border-color: var(--primary);
    color: white;
}

.attachment-btn.delete:hover {
    background: var(--danger);
    border-color: var(--danger);
}

.attachment-btn svg {
    width: 16px;
    height: 16px;
}

/* ========== REPLIES SECTION ========== */
.replies-section {
    margin-top: 40px;
    animation: fadeInUp 0.7s ease;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 20px;
    padding-bottom: 12px;
    border-bottom: 2px solid var(--card-border);
}

.section-icon {
    width: 24px;
    height: 24px;
    color: var(--primary);
    flex-shrink: 0;
}

.section-title {
    font-size: 20px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
}

.reply-count {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 28px;
    height: 28px;
    padding: 0 8px;
    background: var(--primary-light);
    color: var(--primary);
    font-size: 13px;
    font-weight: 700;
    border-radius: 20px;
}

.no-replies {
    text-align: center;
    padding: 40px 20px;
    color: var(--text-muted);
    font-size: 14px;
}

.no-replies svg {
    width: 48px;
    height: 48px;
    margin-bottom: 12px;
    opacity: 0.5;
}

/* ========== REPLY CARD ========== */
.reply-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 16px;
    transition: all 0.3s ease;
    animation: slideIn 0.5s ease;
}

.reply-card:hover {
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    transform: translateY(-2px);
}

.reply-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 12px;
    gap: 12px;
}

.reply-author-info {
    display: flex;
    align-items: center;
    gap: 10px;
}

.reply-avatar {
    width: 36px;
    height: 36px;
    background: var(--primary);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 14px;
}

.reply-author {
    font-weight: 600;
    color: var(--text-primary);
    font-size: 14px;
}

.reply-time {
    display: flex;
    align-items: center;
    gap: 4px;
    font-size: 12px;
    color: var(--text-secondary);
}

.reply-time svg {
    width: 14px;
    height: 14px;
}

.reply-content {
    white-space: pre-wrap;
    line-height: 1.6;
    color: var(--text-primary);
    font-size: 14px;
}

/* ========== REPLY FORM ========== */
.reply-form {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    padding: 24px;
    margin-top: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.form-header {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 16px;
}

.form-header svg {
    width: 20px;
    height: 20px;
    color: var(--primary);
}

.form-header h4 {
    font-size: 16px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
}

.form-textarea {
    width: 100%;
    padding: 12px 16px;
    background: var(--input-bg);
    border: 1px solid var(--input-border);
    border-radius: 10px;
    min-height: 120px;
    margin-bottom: 12px;
    font-size: 14px;
    color: var(--input-text);
    line-height: 1.6;
    resize: vertical;
    transition: all 0.3s ease;
    font-family: inherit;
}

.form-textarea:hover { border-color: var(--primary); }

.form-textarea:focus {
    outline: none;
    border-color: var(--primary);
    background: var(--card-bg);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.form-textarea::placeholder { color: var(--text-muted); opacity: 0.7; }
.form-textarea.error { border-color: var(--danger); animation: shake 0.3s ease; }

.char-counter {
    display: block;
    margin-bottom: 12px;
    font-size: 12px;
    color: var(--text-muted);
    text-align: right;
    font-weight: 500;
}

.char-counter.warning { color: var(--warning); }
.char-counter.danger { color: var(--danger); }

.form-actions {
    display: flex;
    gap: 12px;
}

.btn-submit {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    background: var(--primary);
    color: white;
    border: none;
    border-radius: 10px;
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-submit:hover {
    background: var(--primary-hover);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

.btn-submit.loading { pointer-events: none; opacity: 0.8; }
.btn-submit.loading svg { animation: spin 1s linear infinite; }

.btn-submit svg { width: 18px; height: 18px; }

.btn-cancel {
    padding: 12px 20px;
    background: var(--card-bg);
    color: var(--text-secondary);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-cancel:hover {
    background: var(--body-bg);
    color: var(--text-primary);
}

/* ========== ALERT ========== */
.alert-success {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 14px 18px;
    background: var(--success-light);
    border: 1px solid var(--success);
    color: var(--success);
    border-radius: 10px;
    margin-bottom: 24px;
    font-weight: 500;
    animation: fadeInUp 0.4s ease;
}

.alert-success svg { width: 20px; height: 20px; flex-shrink: 0; }

/* Image Preview Modal */
.image-modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.85);
    z-index: 9999;
    justify-content: center;
    align-items: center;
    padding: 20px;
}

.image-modal.active { display: flex; }

.image-modal img {
    max-width: 90%;
    max-height: 90%;
    border-radius: 8px;
}

.image-modal-close {
    position: absolute;
    top: 20px;
    right: 20px;
    width: 44px;
    height: 44px;
    background: white;
    border: none;
    border-radius: 50%;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
}
</style>

<div class="discussion-view">
    <!-- SUCCESS MESSAGE -->
    @if(session('success'))
    <div class="alert-success">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
            <polyline points="22 4 12 14.01 9 11.01"/>
        </svg>
        {{ session('success') }}
    </div>
    @endif

    <!-- HEADER -->
    <div class="discussion-header">
        <div class="discussion-title-section">
            <a href="{{ route('admin.discussions.index') }}" class="btn-back" title="Back to Discussions">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M19 12H5M12 19l-7-7 7-7"/>
                </svg>
            </a>
            <div class="discussion-title-content">
                <h1>{{ $discussion->title }}</h1>
                @if($discussion->project)
                <div class="project-badge no-link">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                        <polyline points="9 22 9 12 15 12 15 22"/>
                    </svg>
                    {{ $discussion->project->title }}
                </div>
                @else
                <div class="project-badge no-link" style="background: var(--danger-light); border-color: var(--danger); color: var(--danger);">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="12" y1="8" x2="12" y2="12"/>
                        <line x1="12" y1="16" x2="12.01" y2="16"/>
                    </svg>
                    No Project
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- DISCUSSION CARD -->
    <div class="discussion-card">
        <div class="discussion-meta">
            @if($discussion->creator)
            <div class="meta-item">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                    <circle cx="12" cy="7" r="4"/>
                </svg>
                <strong>{{ $discussion->creator->name }}</strong>
            </div>
            <span class="meta-divider"></span>
            @endif
            
            <div class="meta-item">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="12" cy="12" r="10"/>
                    <polyline points="12 6 12 12 16 14"/>
                </svg>
                {{ $discussion->created_at->format('M d, Y') }} at {{ $discussion->created_at->format('h:i A') }}
            </div>

            @if($discussion->portal_visible)
            <span class="meta-divider"></span>
            <div class="status-badge">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                    <circle cx="12" cy="12" r="3"/>
                </svg>
                Portal Visible
            </div>
            @endif
        </div>

        <div class="discussion-content">{{ $discussion->message }}</div>

        <!-- ATTACHMENTS SECTION -->
        @if($discussion->attachments && $discussion->attachments->count() > 0)
        <div class="attachments-section">
            <div class="attachments-header">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M21.44 11.05l-9.19 9.19a6 6 0 0 1-8.49-8.49l9.19-9.19a4 4 0 0 1 5.66 5.66l-9.2 9.19a2 2 0 0 1-2.83-2.83l8.49-8.48"/>
                </svg>
                <h4>Attachments</h4>
                <span class="attachments-count">{{ $discussion->attachments->count() }}</span>
            </div>
            <div class="attachments-grid">
                @foreach($discussion->attachments as $attachment)
                <div class="attachment-item" data-id="{{ $attachment->id }}">
                    @if($attachment->is_image && $attachment->preview_url)
                    <img src="{{ $attachment->preview_url }}" class="attachment-thumbnail" alt="{{ $attachment->file_name }}" onclick="openImageModal(this.src)">
                    @else
                    <div class="attachment-icon {{ $attachment->icon == 'image' ? 'image' : ($attachment->icon == 'file-text' ? 'document' : ($attachment->icon == 'archive' ? 'archive' : '')) }}">
                        @if($attachment->icon == 'image')
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/>
                            <circle cx="8.5" cy="8.5" r="1.5"/>
                            <polyline points="21 15 16 10 5 21"/>
                        </svg>
                        @elseif($attachment->icon == 'file-text')
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                            <polyline points="14 2 14 8 20 8"/>
                            <line x1="16" y1="13" x2="8" y2="13"/>
                            <line x1="16" y1="17" x2="8" y2="17"/>
                        </svg>
                        @elseif($attachment->icon == 'archive')
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 8v13H3V8"/>
                            <path d="M1 3h22v5H1z"/>
                            <path d="M10 12h4"/>
                        </svg>
                        @else
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M13 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V9z"/>
                            <polyline points="13 2 13 9 20 9"/>
                        </svg>
                        @endif
                    </div>
                    @endif
                    <div class="attachment-info">
                        <div class="attachment-name" title="{{ $attachment->file_name }}">{{ $attachment->file_name }}</div>
                        <div class="attachment-size">{{ $attachment->formatted_size }}</div>
                    </div>
                    <div class="attachment-actions">
                        <a href="{{ $attachment->download_url }}" class="attachment-btn" title="Download">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
                                <polyline points="7 10 12 15 17 10"/>
                                <line x1="12" y1="15" x2="12" y2="3"/>
                            </svg>
                        </a>
                        <button type="button" class="attachment-btn delete" title="Delete" onclick="deleteAttachment({{ $attachment->id }})">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="3 6 5 6 21 6"/>
                                <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/>
                            </svg>
                        </button>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>

    <!-- REPLIES SECTION -->
    <div class="replies-section">
        <div class="section-header">
            <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
            </svg>
            <h3 class="section-title">Replies</h3>
            <span class="reply-count">{{ $discussion->replies ? $discussion->replies->count() : 0 }}</span>
        </div>

        @if($discussion->replies && $discussion->replies->count() > 0)
            @foreach($discussion->replies as $reply)
            <div class="reply-card">
                <div class="reply-header">
                    <div class="reply-author-info">
                        <div class="reply-avatar">
                            @if($reply->creator)
                                {{ strtoupper(substr($reply->creator->name, 0, 1)) }}
                            @else
                                ?
                            @endif
                        </div>
                        <div>
                            <div class="reply-author">
                                @if($reply->creator)
                                    {{ $reply->creator->name }}
                                @else
                                    Unknown User
                                @endif
                            </div>
                            <div class="reply-time">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="10"/>
                                    <polyline points="12 6 12 12 16 14"/>
                                </svg>
                                {{ $reply->created_at->diffForHumans() }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="reply-content">{{ $reply->message }}</div>
            </div>
            @endforeach
        @else
        <div class="no-replies">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                <line x1="9" y1="10" x2="15" y2="10"/>
                <line x1="12" y1="7" x2="12" y2="13"/>
            </svg>
            <div>No replies yet. Be the first to respond!</div>
        </div>
        @endif

        <!-- REPLY FORM -->
        <div class="reply-form">
            <div class="form-header">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                    <line x1="9" y1="10" x2="15" y2="10"/>
                    <line x1="12" y1="7" x2="12" y2="13"/>
                </svg>
                <h4>Add Your Reply</h4>
            </div>
            <form action="{{ route('admin.discussions.reply', $discussion->id) }}" method="POST" id="replyForm">
                @csrf
                <textarea 
                    name="message" 
                    id="replyMessage"
                    class="form-textarea" 
                    placeholder="Share your thoughts, feedback, or questions..." 
                    required
                    maxlength="65535"
                ></textarea>
                <span class="char-counter" id="reply-counter">0 / 65535 characters</span>
                <div class="form-actions">
                    <button type="submit" class="btn-submit" id="submitBtn">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <line x1="22" y1="2" x2="11" y2="13"/>
                            <polygon points="22 2 15 22 11 13 2 9 22 2"/>
                        </svg>
                        Post Reply
                    </button>
                    <button type="button" class="btn-cancel" onclick="document.getElementById('replyMessage').value = ''; updateCounter();">
                        Clear
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Image Preview Modal -->
<div class="image-modal" id="imageModal" onclick="closeImageModal()">
    <button class="image-modal-close" onclick="closeImageModal()">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <line x1="18" y1="6" x2="6" y2="18"/>
            <line x1="6" y1="6" x2="18" y2="18"/>
        </svg>
    </button>
    <img src="" alt="Preview" id="modalImage">
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // ========== CHARACTER COUNTER ==========
    const textarea = document.getElementById('replyMessage');
    const counter = document.getElementById('reply-counter');
    const maxLength = 65535;
    
    function updateCounter() {
        if (!textarea || !counter) return;
        
        const current = textarea.value.length;
        counter.textContent = `${current} / ${maxLength} characters`;
        
        counter.classList.remove('warning', 'danger');
        if (current > maxLength * 0.95) {
            counter.classList.add('danger');
        } else if (current > maxLength * 0.85) {
            counter.classList.add('warning');
        }
    }
    
    if (textarea) {
        textarea.addEventListener('input', updateCounter);
        
        // ========== TEXTAREA AUTO-RESIZE ==========
        textarea.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
    }
    
    // ========== FORM VALIDATION ==========
    const form = document.getElementById('replyForm');
    const submitBtn = document.getElementById('submitBtn');
    
    if (form && submitBtn) {
        form.addEventListener('submit', function(e) {
            if (!textarea) return;
            
            const message = textarea.value.trim();
            
            if (!message) {
                e.preventDefault();
                textarea.classList.add('error');
                textarea.focus();
                return false;
            }
            
            submitBtn.classList.add('loading');
            submitBtn.disabled = true;
        });
        
        if (textarea) {
            textarea.addEventListener('input', function() {
                this.classList.remove('error');
            });
        }
    }
    
    // ========== SCROLL TO FORM ON SUCCESS ==========
    @if(session('success'))
    setTimeout(function() {
        const replyForm = document.querySelector('.reply-form');
        if (replyForm) {
            replyForm.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
        }
    }, 500);
    @endif
    
    // Make updateCounter available globally for Clear button
    window.updateCounter = updateCounter;
});

// ========== IMAGE MODAL FUNCTIONS ==========
function openImageModal(src) {
    const modal = document.getElementById('imageModal');
    const img = document.getElementById('modalImage');
    img.src = src;
    modal.classList.add('active');
}

function closeImageModal() {
    const modal = document.getElementById('imageModal');
    modal.classList.remove('active');
}

// Close modal with Escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeImageModal();
    }
});

// ========== DELETE ATTACHMENT ==========
function deleteAttachment(attachmentId) {
    if (!confirm('Are you sure you want to delete this attachment?')) {
        return;
    }
    
    fetch(`{{ url('admin/discussions/attachment') }}/${attachmentId}`, {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Remove the attachment item from DOM
            const item = document.querySelector(`.attachment-item[data-id="${attachmentId}"]`);
            if (item) {
                item.style.animation = 'fadeInUp 0.3s ease reverse';
                setTimeout(() => item.remove(), 300);
            }
            
            // Update count
            const countEl = document.querySelector('.attachments-count');
            if (countEl) {
                const newCount = parseInt(countEl.textContent) - 1;
                countEl.textContent = newCount;
                
                // Hide section if no attachments left
                if (newCount === 0) {
                    document.querySelector('.attachments-section').remove();
                }
            }
        } else {
            alert(data.message || 'Failed to delete attachment');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to delete attachment');
    });
}
</script>