{{-- Project Management Module - Admin Sidebar Menu --}}
{!! admin_menu([
    'title' => 'Project Management',
    'icon' => 'briefcase',
    'route' => 'admin.project-management.*,admin.projects.*,admin.tasks.*,admin.timelogs.*,admin.milestones.*,admin.discussions.*',
    'active_check' => function($route) {
        return request()->routeIs('admin.project-management.*') 
            || request()->routeIs('admin.projects.*')
            || request()->routeIs('admin.tasks.*')
            || request()->routeIs('admin.timelogs.*')
            || request()->routeIs('admin.milestones.*')
            || request()->routeIs('admin.discussions.*');
    },
    'children' => [
        ['title' => 'Dashboard', 'route' => 'admin.project-management.dashboard', 'icon' => 'chart'],
        ['title' => 'Projects', 'route' => 'admin.projects.index', 'icon' => 'folder'],
        ['title' => 'Tasks', 'route' => 'admin.tasks.index', 'icon' => 'clipboard'],
        ['title' => 'Time Logs', 'route' => 'admin.timelogs.index', 'icon' => 'clock'],
        ['title' => 'Milestones', 'route' => 'admin.milestones.index', 'icon' => 'flag'],
        ['title' => 'Discussions', 'route' => 'admin.discussions.index', 'icon' => 'message-square'],
    ]
]) !!}