<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
/* ========== ANIMATIONS ========== */
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideIn {
    from { opacity: 0; transform: translateX(-10px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

/* ========== BASE LAYOUT ========== */
.form-page { 
    max-width: 900px; 
    margin: 0 auto; 
    padding: 24px;
    animation: fadeInUp 0.5s ease;
    min-height: 100vh;
}

/* ========== HEADER ========== */
.form-header { 
    display: flex; 
    align-items: center; 
    gap: 16px; 
    margin-bottom: 28px;
    animation: slideIn 0.3s ease;
}

.form-header h1 {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    letter-spacing: -0.02em;
    display: flex;
    align-items: center;
    gap: 12px;
}

.edit-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: var(--warning-light);
    color: var(--warning);
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    border: 1px solid var(--warning);
}

.edit-badge svg {
    width: 14px;
    height: 14px;
}

.btn-back {
    width: 42px; 
    height: 42px;
    display: flex; 
    align-items: center; 
    justify-content: center;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    text-decoration: none;
    color: var(--text-secondary);
    transition: all 0.3s ease;
    flex-shrink: 0;
}

.btn-back:hover {
    background: var(--primary);
    color: white;
    border-color: var(--primary);
    transform: translateX(-3px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

/* ========== FORM CARD ========== */
.form-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    animation: fadeInUp 0.6s ease;
}

.form-card-body { 
    padding: 28px;
}

/* ========== SECTION HEADERS ========== */
.section-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 24px;
    padding-bottom: 14px;
    border-bottom: 2px solid var(--card-border);
    animation: slideIn 0.4s ease;
}

.section-icon {
    width: 24px;
    height: 24px;
    color: var(--primary);
    flex-shrink: 0;
}

.section-title {
    font-size: 17px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    letter-spacing: -0.01em;
}

.section-divider {
    height: 1px;
    background: var(--card-border);
    margin: 32px 0;
}

/* ========== FORM GROUPS ========== */
.form-group { 
    margin-bottom: 20px;
    animation: fadeInUp 0.5s ease;
    animation-fill-mode: backwards;
}

.form-group:nth-child(1) { animation-delay: 0.05s; }
.form-group:nth-child(2) { animation-delay: 0.1s; }
.form-group:nth-child(3) { animation-delay: 0.15s; }
.form-group:nth-child(4) { animation-delay: 0.2s; }

.form-label {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 8px;
    color: var(--text-primary);
}

.label-icon {
    width: 16px;
    height: 16px;
    color: var(--text-secondary);
}

.label-hint {
    font-size: 12px;
    font-weight: 400;
    color: var(--text-muted);
    margin-left: auto;
}

/* ========== FORM INPUTS ========== */
.form-input, 
.form-select, 
.form-textarea {
    width: 100%;
    padding: 12px 16px;
    background: var(--input-bg);
    border: 1px solid var(--input-border);
    border-radius: 10px;
    font-size: 14px;
    color: var(--input-text);
    transition: all 0.3s ease;
    font-family: inherit;
}

.form-input:hover, 
.form-select:hover, 
.form-textarea:hover {
    border-color: var(--primary);
}

.form-input:focus, 
.form-select:focus, 
.form-textarea:focus {
    outline: none;
    border-color: var(--primary);
    background: var(--card-bg);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    transform: translateY(-1px);
}

.form-input::placeholder,
.form-textarea::placeholder {
    color: var(--text-muted);
    opacity: 0.7;
}

.form-textarea { 
    min-height: 120px; 
    resize: vertical;
    line-height: 1.6;
}

/* ========== ERROR STATES ========== */
.form-input.error, 
.form-select.error, 
.form-textarea.error {
    border-color: var(--danger);
    animation: shake 0.3s ease;
}

.form-error {
    display: block;
    margin-top: 6px;
    font-size: 13px;
    color: var(--danger);
    font-weight: 500;
}

/* ========== FORM ROWS ========== */
.form-row {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 16px;
}

.form-row-3 {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 16px;
}

@media (max-width: 768px) {
    .form-row, 
    .form-row-3 {
        grid-template-columns: 1fr;
    }
}

/* ========== FORM ACTIONS ========== */
.form-actions {
    padding: 20px 28px;
    border-top: 1px solid var(--card-border);
    display: flex;
    gap: 12px;
    background: var(--body-bg);
}

.btn-submit {
    padding: 12px 24px;
    background: var(--warning);
    color: white;
    border: none;
    border-radius: 10px;
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-submit:hover { 
    background: var(--warning-hover, #d97706);
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(245, 158, 11, 0.4);
}

.btn-submit:active {
    transform: translateY(0);
}

.btn-submit.loading {
    position: relative;
    pointer-events: none;
    opacity: 0.7;
}

.btn-submit.loading::after {
    content: '';
    position: absolute;
    width: 16px;
    height: 16px;
    border: 2px solid white;
    border-top-color: transparent;
    border-radius: 50%;
    animation: spin 0.6s linear infinite;
    right: 12px;
}

.btn-cancel {
    padding: 12px 24px;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    text-decoration: none;
    color: var(--text-primary);
    font-weight: 600;
    font-size: 14px;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-cancel:hover {
    background: var(--danger-light);
    border-color: var(--danger);
    color: var(--danger);
    transform: translateY(-2px);
}

/* ========== REQUIRED INDICATOR ========== */
.required { 
    color: var(--danger);
    font-weight: bold;
    margin-left: 2px;
}

/* ========== ALERT ERRORS ========== */
.alert-errors {
    background: var(--danger-light);
    border: 1px solid var(--danger);
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    color: var(--danger);
    animation: slideIn 0.4s ease;
}

.alert-errors strong {
    display: block;
    margin-bottom: 8px;
    font-size: 14px;
}

.alert-errors ul {
    margin: 0;
    padding-left: 20px;
}

.alert-errors li {
    margin: 6px 0;
    font-size: 13px;
}

/* ========== CHECKBOX STYLING ========== */
.form-checkbox {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-top: 8px;
    padding: 14px 16px;
    background: var(--primary-light);
    border-radius: 10px;
    transition: all 0.3s ease;
    border: 1px solid transparent;
}

.form-checkbox:hover {
    background: rgba(59, 130, 246, 0.15);
    border-color: var(--primary);
}

.form-checkbox input[type="checkbox"] {
    width: 20px;
    height: 20px;
    cursor: pointer;
    accent-color: var(--primary);
    flex-shrink: 0;
}

.form-checkbox label {
    cursor: pointer;
    user-select: none;
    font-weight: 500;
    color: var(--text-primary);
    font-size: 14px;
    margin: 0;
}

/* ========== HELPER TEXT ========== */
.form-help {
    display: block;
    margin-top: 6px;
    font-size: 12px;
    color: var(--text-muted);
    line-height: 1.4;
}

.form-help svg {
    width: 14px;
    height: 14px;
    display: inline-block;
    vertical-align: middle;
    margin-right: 4px;
    color: var(--primary);
}

/* ========== CHARACTER COUNTER ========== */
.char-counter {
    display: block;
    margin-top: 6px;
    font-size: 12px;
    color: var(--text-muted);
    text-align: right;
    font-weight: 500;
}

.char-counter.warning {
    color: var(--warning);
}

.char-counter.danger {
    color: var(--danger);
}

/* ========== SELECT2 CUSTOM STYLING ========== */
.select2-container--default .select2-selection--multiple {
    background: var(--input-bg);
    border: 1px solid var(--input-border);
    border-radius: 10px;
    padding: 6px 12px;
    min-height: 48px;
    transition: all 0.3s ease;
}

.select2-container--default .select2-selection--multiple:hover {
    border-color: var(--primary);
}

.select2-container--default.select2-container--focus .select2-selection--multiple {
    border-color: var(--primary);
    background: var(--card-bg);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.select2-container--default .select2-selection--multiple .select2-selection__choice {
    background: var(--primary);
    border: none;
    border-radius: 6px;
    padding: 5px 12px;
    color: white;
    margin: 4px 4px 4px 0;
    transition: all 0.2s ease;
    font-weight: 500;
}

.select2-container--default .select2-selection--multiple .select2-selection__choice:hover {
    background: var(--primary-hover);
    transform: scale(1.05);
}

.select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
    color: white;
    margin-right: 6px;
    transition: color 0.2s ease;
    font-weight: bold;
}

.select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
    color: rgba(255, 255, 255, 0.8);
}

.select2-container--default .select2-search--inline .select2-search__field {
    margin-top: 6px;
    color: var(--input-text);
}

.select2-container--default .select2-search--inline .select2-search__field::placeholder {
    color: var(--text-muted);
}

/* ========================================
   SELECT2 DROPDOWN OPTIONS - NUCLEAR FIX
   Forces visible text in all themes
   ======================================== */

/* Base dropdown container */
.select2-dropdown {
    background: var(--card-bg) !important;
    border: 1px solid var(--input-border) !important;
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    animation: fadeInUp 0.2s ease;
}

/* Dropdown options - FORCE VISIBLE TEXT */
.select2-container--default .select2-results__option {
    padding: 10px 14px !important;
    background: var(--card-bg) !important;
}

/* CRITICAL: Force text visibility with fallbacks */
.select2-container--default .select2-results__option,
.select2-results__option span {
    color: var(--text-primary, #1e293b) !important;
    font-weight: 500 !important;
}

/* Dark theme - explicit light text */
[data-theme="dark"] .select2-container--default .select2-results__option,
[data-theme="dark"] .select2-results__option span {
    color: #f1f5f9 !important;
}

/* Light theme - explicit dark text */
[data-theme="light"] .select2-container--default .select2-results__option,
[data-theme="light"] .select2-results__option span {
    color: #1e293b !important;
}

/* Highlighted option (hover) */
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background: var(--primary) !important;
    color: white !important;
}

.select2-container--default .select2-results__option--highlighted[aria-selected] span {
    color: white !important;
}

/* Selected/checked option */
.select2-container--default .select2-results__option[aria-selected=true] {
    background: var(--primary-light) !important;
    color: var(--primary) !important;
    font-weight: 600 !important;
}

.select2-container--default .select2-results__option[aria-selected=true] span {
    color: var(--primary) !important;
}

/* Search field in dropdown */
.select2-container--default .select2-search--dropdown .select2-search__field {
    background: var(--input-bg) !important;
    border: 1px solid var(--input-border) !important;
    color: var(--input-text) !important;
    border-radius: 8px;
    padding: 8px 12px;
}

/* Dark theme search field */
[data-theme="dark"] .select2-container--default .select2-search--dropdown .select2-search__field {
    color: #f1f5f9 !important;
}

.select2-container--default .select2-search--dropdown .select2-search__field:focus {
    border-color: var(--primary) !important;
    outline: none;
}

/* Search field placeholder */
.select2-container--default .select2-search--dropdown .select2-search__field::placeholder {
    color: var(--text-muted) !important;
}

/* ========== STATUS SELECT WITH COLORED TEXT ========== */
#status-select {
    font-weight: 600;
    transition: all 0.3s ease;
}

.status-option {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 8px 12px;
}

.status-dot {
    width: 10px;
    height: 10px;
    border-radius: 50%;
    flex-shrink: 0;
    display: inline-block;
    margin-right: 8px;
    border: 2px solid rgba(0, 0, 0, 0.1);
}

/* ========== BILLING METHOD HIGHLIGHT ========== */
.billing-highlight {
    background: rgba(245, 158, 11, 0.08);
    border: 1px solid rgba(245, 158, 11, 0.2);
    transition: all 0.3s ease;
}

/* ========== PROJECT INFO BADGE ========== */
.project-info-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: var(--primary-light);
    color: var(--primary);
    border-radius: 8px;
    font-size: 12px;
    font-weight: 600;
    margin-left: 12px;
}

.project-info-badge svg {
    width: 14px;
    height: 14px;
}

/* ========== RESPONSIVE ========== */
@media (max-width: 768px) {
    .form-page {
        padding: 16px;
    }
    
    .form-header h1 {
        font-size: 22px;
        flex-wrap: wrap;
    }
    
    .edit-badge,
    .project-info-badge {
        margin-left: 0;
        margin-top: 8px;
    }
    
    .form-card-body {
        padding: 20px;
    }
    
    .form-actions {
        flex-direction: column;
    }
    
    .btn-submit,
    .btn-cancel {
        width: 100%;
        justify-content: center;
    }
}
</style>

<div class="form-page">
    <!-- HEADER -->
    <div class="form-header">
        <a href="{{ route('admin.projects.show', $project->id) }}" class="btn-back" title="Back to Project">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M19 12H5M12 19l-7-7 7-7"/>
            </svg>
        </a>
        <h1>
            Edit Project
            <span class="edit-badge">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/>
                    <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"/>
                </svg>
                Editing
            </span>
            <span class="project-info-badge">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M13 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V9z"/>
                    <polyline points="13 2 13 9 20 9"/>
                </svg>
                ID: #{{ $project->id }}
            </span>
        </h1>
    </div>

    <!-- ERROR ALERTS -->
    @if($errors->any())
    <div class="alert-errors">
        <strong>⚠️ Please fix the following errors:</strong>
        <ul>
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <!-- FORM -->
    <form action="{{ route('admin.projects.update', $project->id) }}" method="POST" id="projectForm">
        @csrf
        @method('PUT')
        <div class="form-card">
            <div class="form-card-body">
                
                <!-- ========== PROJECT INFORMATION ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                        <polyline points="9 22 9 12 15 12 15 22"/>
                    </svg>
                    <h3 class="section-title">Project Information</h3>
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M4 7h16M4 12h16M4 17h10"/>
                        </svg>
                        Project Title <span class="required">*</span>
                    </label>
                    <input 
                        type="text" 
                        name="title" 
                        class="form-input" 
                        value="{{ old('title', $project->title) }}" 
                        placeholder="Enter project title"
                        required
                        maxlength="191"
                        autocomplete="off"
                    >
                    @error('title')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                                <circle cx="12" cy="7" r="4"/>
                            </svg>
                            Customer
                        </label>
                        <select name="account_id" class="form-select">
                            <option value="">-- Select Customer --</option>
                            @foreach($customers as $customer)
                            <option value="{{ $customer->id }}" {{ old('account_id', $project->account_id) == $customer->id ? 'selected' : '' }}>
                                {{ $customer->display_name }}
                            </option>
                            @endforeach
                        </select>
                        @error('account_id')
                        <span class="form-error">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="10"/>
                                <path d="M12 6v6l4 2"/>
                            </svg>
                            Status <span class="required">*</span>
                        </label>
                        <select name="status_id" id="status-select" class="form-select" required>
                            @foreach($statuses as $status)
                            <option 
                                value="{{ $status->id }}" 
                                data-color="{{ $status->color ?? '#6B7280' }}"
                                {{ old('status_id', $project->status_id) == $status->id ? 'selected' : '' }}
                            >
                                {{ $status->label }}
                            </option>
                            @endforeach
                        </select>
                        @error('status_id')
                        <span class="form-error">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="section-divider"></div>

                <!-- ========== Project Value ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="1" y="4" width="22" height="16" rx="2" ry="2"/>
                        <line x1="1" y1="10" x2="23" y2="10"/>
                    </svg>
                    <h3 class="section-title">Project Value</h3>
                </div>

                <div class="form-row-3">
                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                            </svg>
                            Billing Method <span class="required">*</span>
                        </label>
                        <select name="billing_method" class="form-select" id="billing_method" required>
                            <option value="fixed" {{ old('billing_method', $project->billing_method) == 'fixed' ? 'selected' : '' }}>Fixed Amount</option>
                            <option value="project_hours" {{ old('billing_method', $project->billing_method) == 'project_hours' ? 'selected' : '' }}>Project Hours</option>
                            <option value="task_hours" {{ old('billing_method', $project->billing_method) == 'task_hours' ? 'selected' : '' }}>Task Hours</option>
                        </select>
                        @error('billing_method')
                        <span class="form-error">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group" id="fixed-amount-group">
                        <label class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="12" y1="1" x2="12" y2="23"/>
                                <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                            </svg>
                            Fixed Amount
                        </label>
                        <input 
                            type="number" 
                            name="fixed_amount" 
                            class="form-input" 
                            step="0.01" 
                            min="0"
                            placeholder="e.g., 50000.00"
                            value="{{ old('fixed_amount', $project->fixed_amount) }}"
                        >
                        @error('fixed_amount')
                        <span class="form-error">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group" id="hourly-rate-group">
                        <label class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="10"/>
                                <polyline points="12 6 12 12 16 14"/>
                            </svg>
                            Hourly Rate
                        </label>
                        <input 
                            type="number" 
                            name="hourly_rate" 
                            class="form-input" 
                            step="0.01" 
                            min="0"
                            placeholder="e.g., 500.00"
                            value="{{ old('hourly_rate', $project->hourly_rate) }}"
                        >
                        @error('hourly_rate')
                        <span class="form-error">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="section-divider"></div>

                <!-- ========== PROJECT TIMELINE ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                        <line x1="16" y1="2" x2="16" y2="6"/>
                        <line x1="8" y1="2" x2="8" y2="6"/>
                        <line x1="3" y1="10" x2="21" y2="10"/>
                    </svg>
                    <h3 class="section-title">Project Timeline</h3>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polygon points="5 3 19 12 5 21 5 3"/>
                            </svg>
                            Planned Start Date
                        </label>
                        <input 
                            type="date" 
                            name="planned_start_date" 
                            id="start-date"
                            class="form-input"
                            value="{{ old('planned_start_date', $project->planned_start_date ? $project->planned_start_date->format('Y-m-d') : '') }}"
                        >
                        @error('planned_start_date')
                        <span class="form-error">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                                <line x1="16" y1="2" x2="16" y2="6"/>
                                <line x1="8" y1="2" x2="8" y2="6"/>
                                <line x1="3" y1="10" x2="21" y2="10"/>
                                <path d="M8 14h.01M12 14h.01M16 14h.01M8 18h.01M12 18h.01M16 18h.01"/>
                            </svg>
                            Planned End Date
                        </label>
                        <input 
                            type="date" 
                            name="planned_end_date" 
                            id="end-date"
                            class="form-input"
                            value="{{ old('planned_end_date', $project->planned_end_date ? $project->planned_end_date->format('Y-m-d') : '') }}"
                        >
                        @error('planned_end_date')
                        <span class="form-error">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="section-divider"></div>

                <!-- ========== PROJECT NOTES ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                        <polyline points="14 2 14 8 20 8"/>
                        <line x1="16" y1="13" x2="8" y2="13"/>
                        <line x1="16" y1="17" x2="8" y2="17"/>
                        <polyline points="10 9 9 9 8 9"/>
                    </svg>
                    <h3 class="section-title">Project Notes & Documentation</h3>
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/>
                            <polyline points="3.27 6.96 12 12.01 20.73 6.96"/>
                            <line x1="12" y1="22.08" x2="12" y2="12"/>
                        </svg>
                        Scope Notes
                        <span class="label-hint">Optional</span>
                    </label>
                    <textarea 
                        name="scope_notes" 
                        id="scope-notes"
                        class="form-textarea"
                        placeholder="Describe project scope, deliverables, requirements, and acceptance criteria..."
                        maxlength="65535"
                    >{{ old('scope_notes', $project->scope_notes) }}</textarea>
                    <span class="char-counter" id="scope-counter">{{ strlen($project->scope_notes ?? '') }} / 65535 characters</span>
                    @error('scope_notes')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="3" y="11" width="18" height="11" rx="2" ry="2"/>
                            <path d="M7 11V7a5 5 0 0 1 10 0v4"/>
                        </svg>
                        Internal Notes (Private)
                        <span class="label-hint">Not visible to customer</span>
                    </label>
                    <textarea 
                        name="internal_notes" 
                        id="internal-notes"
                        class="form-textarea"
                        placeholder="Internal notes, risks, assumptions, technical details (not visible to customer)..."
                        maxlength="65535"
                    >{{ old('internal_notes', $project->internal_notes) }}</textarea>
                    <span class="char-counter" id="internal-counter">{{ strlen($project->internal_notes ?? '') }} / 65535 characters</span>
                    @error('internal_notes')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="section-divider"></div>

                <!-- ========== TEAM MEMBERS ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                        <circle cx="9" cy="7" r="4"/>
                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                        <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                    </svg>
                    <h3 class="section-title">Team Members</h3>
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                            <circle cx="8.5" cy="7" r="4"/>
                            <polyline points="17 11 19 13 23 9"/>
                        </svg>
                        Assign Team Members
                    </label>
                    <select name="team[]" id="team-members" class="form-select" multiple style="width: 100%;">
                        @foreach($admins as $admin)
                        <option value="{{ $admin->id }}" {{ in_array($admin->id, old('team', $project->team->pluck('id')->toArray())) ? 'selected' : '' }}>
                            {{ $admin->name }}
                        </option>
                        @endforeach
                    </select>
                    <span class="form-help">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"/>
                            <path d="M12 16v-4M12 8h.01"/>
                        </svg>
                        Currently {{ $project->team->count() }} team member(s) assigned
                    </span>
                    @error('team')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                    @error('team.*')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-checkbox">
                    <input 
                        type="checkbox" 
                        name="is_billable" 
                        id="is_billable" 
                        value="1" 
                        {{ old('is_billable', $project->is_billable) ? 'checked' : '' }}
                    >
                    <label for="is_billable">
                        <strong>Mark as Billable Project</strong> — Time logged will be included in invoicing
                    </label>
                </div>
            </div>

            <!-- ========== FORM ACTIONS ========== -->
            <div class="form-actions">
                <button type="submit" class="btn-submit" id="submitBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
                        <polyline points="17 21 17 13 7 13 7 21"/>
                        <polyline points="7 3 7 8 15 8"/>
                    </svg>
                    Update Project
                </button>
                <a href="{{ route('admin.projects.show', $project->id) }}" class="btn-cancel">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="15" y1="9" x2="9" y2="15"/>
                        <line x1="9" y1="9" x2="15" y2="15"/>
                    </svg>
                    Cancel
                </a>
            </div>
        </div>
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    // ========== SELECT2 INITIALIZATION ==========
    $('#team-members').select2({
        placeholder: 'Search and select team members...',
        allowClear: true,
        closeOnSelect: false,
        width: '100%',
        theme: 'default',
        language: {
            noResults: function() {
                return "No team members found";
            },
            searching: function() {
                return "Searching...";
            }
        }
    });

    // ========== STATUS COLOR STYLING ==========
    const statusSelect = document.getElementById('status-select');
    if (statusSelect) {
        function updateStatusColor() {
            const selectedOption = statusSelect.options[statusSelect.selectedIndex];
            const color = selectedOption.getAttribute('data-color') || '#6B7280';
            statusSelect.style.color = color;
        }
        
        statusSelect.addEventListener('change', updateStatusColor);
        updateStatusColor(); // Set initial color
        
        // Style dropdown options
        Array.from(statusSelect.options).forEach(option => {
            const color = option.getAttribute('data-color') || '#6B7280';
            option.style.background = `linear-gradient(to right, ${color}15 0%, transparent 100%)`;
            option.style.borderLeft = `4px solid ${color}`;
            option.style.paddingLeft = '12px';
            option.style.color = color;
            option.style.fontWeight = '600';
        });
    }

    // ========== BILLING METHOD HIGHLIGHTING ==========
    const billingMethodSelect = document.getElementById('billing_method');
    const fixedAmountGroup = document.getElementById('fixed-amount-group');
    const hourlyRateGroup = document.getElementById('hourly-rate-group');
    
    function updateBillingHighlight() {
        const method = billingMethodSelect.value;
        
        fixedAmountGroup.classList.remove('billing-highlight');
        hourlyRateGroup.classList.remove('billing-highlight');
        
        if (method === 'fixed') {
            fixedAmountGroup.classList.add('billing-highlight');
        } else if (method === 'project_hours' || method === 'task_hours') {
            hourlyRateGroup.classList.add('billing-highlight');
        }
    }
    
    billingMethodSelect.addEventListener('change', updateBillingHighlight);
    updateBillingHighlight(); // Set initial state

    // ========== DATE VALIDATION ==========
    const startDate = document.getElementById('start-date');
    const endDate = document.getElementById('end-date');
    
    endDate.addEventListener('change', function() {
        if (startDate.value && endDate.value) {
            if (new Date(endDate.value) < new Date(startDate.value)) {
                alert('⚠️ End date cannot be before start date!');
                endDate.value = '';
                endDate.classList.add('error');
                setTimeout(() => endDate.classList.remove('error'), 2000);
            }
        }
    });

    // ========== CHARACTER COUNTERS ==========
    function setupCharCounter(textareaId, counterId, maxLength) {
        const textarea = document.getElementById(textareaId);
        const counter = document.getElementById(counterId);
        
        if (textarea && counter) {
            textarea.addEventListener('input', function() {
                const current = this.value.length;
                counter.textContent = `${current} / ${maxLength} characters`;
                
                counter.classList.remove('warning', 'danger');
                if (current > maxLength * 0.95) {
                    counter.classList.add('danger');
                } else if (current > maxLength * 0.85) {
                    counter.classList.add('warning');
                }
            });
        }
    }
    
    setupCharCounter('scope-notes', 'scope-counter', 65535);
    setupCharCounter('internal-notes', 'internal-counter', 65535);

    // ========== FORM VALIDATION & SUBMISSION ==========
    const form = document.getElementById('projectForm');
    const submitBtn = document.getElementById('submitBtn');
    
    form.addEventListener('submit', function(e) {
        submitBtn.classList.add('loading');
        submitBtn.disabled = true;
        
        const title = form.querySelector('[name="title"]');
        const statusId = form.querySelector('[name="status_id"]');
        const billingMethod = form.querySelector('[name="billing_method"]');
        
        // Validate title
        if (!title.value.trim()) {
            e.preventDefault();
            title.classList.add('error');
            title.focus();
            resetSubmitButton();
            return false;
        }
        
        // Validate status
        if (!statusId.value) {
            e.preventDefault();
            statusId.classList.add('error');
            statusId.focus();
            resetSubmitButton();
            return false;
        }
        
        // Validate billing method
        if (!billingMethod.value) {
            e.preventDefault();
            billingMethod.classList.add('error');
            billingMethod.focus();
            resetSubmitButton();
            return false;
        }
    });
    
    function resetSubmitButton() {
        submitBtn.classList.remove('loading');
        submitBtn.disabled = false;
    }
    
    // Remove error class on input
    form.querySelectorAll('.form-input, .form-select, .form-textarea').forEach(input => {
        input.addEventListener('input', function() {
            this.classList.remove('error');
        });
    });

    // ========== AUTO-FOCUS ==========
    setTimeout(() => {
        document.querySelector('[name="title"]').focus();
    }, 300);

    // ========== CONFIRM NAVIGATION AWAY IF FORM DIRTY ==========
    let formDirty = false;
    const originalValues = {};
    
    // Store original values
    form.querySelectorAll('input, select, textarea').forEach(field => {
        if (field.type === 'checkbox') {
            originalValues[field.name] = field.checked;
        } else {
            originalValues[field.name] = field.value;
        }
    });
    
    // Track changes
    form.querySelectorAll('input, select, textarea').forEach(field => {
        field.addEventListener('change', function() {
            if (this.type === 'checkbox') {
                formDirty = originalValues[this.name] !== this.checked;
            } else {
                formDirty = originalValues[this.name] !== this.value;
            }
        });
    });
    
    window.addEventListener('beforeunload', function(e) {
        if (formDirty && !submitBtn.classList.contains('loading')) {
            e.preventDefault();
            e.returnValue = '';
        }
    });
    
    form.addEventListener('submit', () => formDirty = false);
});
</script>