<style>
/* ========================================
   Time Log Detail - Theme-Aware Styles
   ======================================== */

/* Page Animation */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideIn {
    from { opacity: 0; transform: translateX(-20px); }
    to { opacity: 1; transform: translateX(0); }
}

.timelog-detail-page {
    padding: var(--space-xl);
    animation: fadeIn 0.4s ease;
    max-width: 1200px;
    margin: 0 auto;
}

/* Page Header */
.page-header {
    display: flex;
    align-items: center;
    gap: var(--space-lg);
    margin-bottom: var(--space-xl);
}

.btn-back {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-lg);
    text-decoration: none;
    color: var(--text-primary);
    transition: all 0.3s ease;
}

.btn-back:hover {
    background: var(--primary);
    border-color: var(--primary);
    color: white;
    transform: translateY(-2px);
}

.btn-back svg {
    width: 20px;
    height: 20px;
}

.page-title-section h1 {
    font-size: var(--font-xl);
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 var(--space-xs) 0;
    display: flex;
    align-items: center;
    gap: var(--space-sm);
}

.page-title-section h1 svg {
    width: 28px;
    height: 28px;
    color: var(--primary);
}

.page-subtitle {
    font-size: var(--font-sm);
    color: var(--text-secondary);
    margin: 0;
}

/* Content Grid */
.content-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: var(--space-xl);
    margin-bottom: var(--space-xl);
}

@media (max-width: 968px) {
    .content-grid {
        grid-template-columns: 1fr;
    }
}

/* Info Card */
.info-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-lg);
    overflow: hidden;
    animation: slideIn 0.3s ease;
    transition: all 0.3s ease;
}

.info-card:hover {
    box-shadow: var(--shadow-md);
}

.card-header {
    padding: var(--space-lg);
    border-bottom: 1px solid var(--card-border);
    background: var(--body-bg);
}

.card-title {
    font-size: var(--font-lg);
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
    display: flex;
    align-items: center;
    gap: var(--space-sm);
}

.card-title svg {
    width: 20px;
    height: 20px;
    color: var(--primary);
}

.card-body {
    padding: var(--space-lg);
}

/* Info Grid */
.info-grid {
    display: grid;
    gap: var(--space-lg);
}

.info-item {
    display: flex;
    flex-direction: column;
    gap: var(--space-xs);
}

.info-label {
    font-size: var(--font-xs);
    font-weight: 600;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    display: flex;
    align-items: center;
    gap: var(--space-xs);
}

.info-label svg {
    width: 14px;
    height: 14px;
    color: var(--text-muted);
}

.info-value {
    font-size: var(--font-md);
    color: var(--text-primary);
    font-weight: 500;
}

.info-value-large {
    font-size: 32px;
    font-weight: 700;
    color: var(--primary);
    letter-spacing: -0.02em;
}

/* Status Badge */
.status-badge {
    display: inline-flex;
    align-items: center;
    gap: var(--space-xs);
    padding: 6px 12px;
    border-radius: 12px;
    font-size: var(--font-sm);
    font-weight: 600;
}

.status-badge.running {
    background: var(--warning-light);
    color: var(--warning);
}

.status-badge.completed {
    background: var(--success-light);
    color: var(--success);
}

.status-badge svg {
    width: 14px;
    height: 14px;
}

/* Link Button */
.link-item {
    display: flex;
    align-items: center;
    gap: var(--space-sm);
    padding: var(--space-sm) 0;
    color: var(--primary);
    text-decoration: none;
    font-weight: 500;
    transition: all 0.2s ease;
}

.link-item:hover {
    color: var(--primary-hover);
    transform: translateX(4px);
}

.link-item svg {
    width: 18px;
    height: 18px;
}

/* Location Card */
.location-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-lg);
    overflow: hidden;
    animation: slideIn 0.4s ease;
}

.location-header {
    padding: var(--space-lg);
    border-bottom: 1px solid var(--card-border);
    background: var(--body-bg);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.location-title {
    font-size: var(--font-lg);
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
    display: flex;
    align-items: center;
    gap: var(--space-sm);
}

.location-title svg {
    width: 20px;
    height: 20px;
    color: var(--success);
}

.btn-map {
    display: inline-flex;
    align-items: center;
    gap: var(--space-xs);
    padding: 8px 16px;
    background: var(--success);
    color: white;
    border-radius: var(--radius-md);
    text-decoration: none;
    font-size: var(--font-sm);
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-map:hover {
    background: var(--primary);
    transform: translateY(-2px);
    box-shadow: var(--shadow-sm);
}

.btn-map svg {
    width: 16px;
    height: 16px;
}

/* Location Details */
.location-details {
    padding: var(--space-lg);
}

.location-info {
    display: grid;
    gap: var(--space-md);
    margin-bottom: var(--space-lg);
}

.location-row {
    display: flex;
    align-items: center;
    gap: var(--space-sm);
    padding: var(--space-sm);
    background: var(--body-bg);
    border-radius: var(--radius-md);
}

.location-row svg {
    width: 18px;
    height: 18px;
    color: var(--primary);
    flex-shrink: 0;
}

.location-text {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.location-text-label {
    font-size: var(--font-xs);
    color: var(--text-secondary);
    font-weight: 500;
}

.location-text-value {
    font-size: var(--font-base);
    color: var(--text-primary);
    font-weight: 500;
    font-family: monospace;
}

/* Map Container */
.map-container {
    position: relative;
    width: 100%;
    height: 400px;
    background: var(--body-bg);
    border-radius: var(--radius-lg);
    overflow: hidden;
    margin-top: var(--space-lg);
}

.map-frame {
    width: 100%;
    height: 100%;
    border: none;
}

.map-placeholder {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 100%;
    gap: var(--space-md);
}

.map-placeholder svg {
    width: 64px;
    height: 64px;
    color: var(--text-muted);
}

.map-placeholder p {
    font-size: var(--font-base);
    color: var(--text-secondary);
    margin: 0;
}

/* Accuracy Badge */
.accuracy-badge {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 10px;
    background: var(--primary-light);
    border-radius: 12px;
    font-size: var(--font-xs);
    font-weight: 600;
    color: var(--primary);
}

.accuracy-badge svg {
    width: 12px;
    height: 12px;
}

/* No Location Message */
.no-location-card {
    background: var(--warning-light);
    border: 1px solid var(--warning);
    border-radius: var(--radius-lg);
    padding: var(--space-lg);
    display: flex;
    align-items: center;
    gap: var(--space-md);
}

.no-location-card svg {
    width: 40px;
    height: 40px;
    color: var(--warning);
    flex-shrink: 0;
}

.no-location-text h4 {
    font-size: var(--font-md);
    color: var(--warning);
    margin: 0 0 var(--space-xs) 0;
    font-weight: 600;
}

.no-location-text p {
    font-size: var(--font-sm);
    color: var(--text-secondary);
    margin: 0;
}

/* Divider */
.divider {
    height: 1px;
    background: var(--card-border);
    margin: var(--space-lg) 0;
}
</style>

<div class="timelog-detail-page">
    {{-- Page Header --}}
    <div class="page-header">
        <a href="{{ route('admin.timelogs.index') }}" class="btn-back">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <div class="page-title-section">
            <h1>
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Time Log Details
            </h1>
            <p class="page-subtitle">Time Log #{{ $timeLog->id }} · {{ $timeLog->created_at->format('M d, Y') }}</p>
        </div>
    </div>

    {{-- Content Grid --}}
    <div class="content-grid">
        {{-- Main Details --}}
        <div>
            {{-- Task Information --}}
            <div class="info-card" style="margin-bottom: var(--space-xl);">
                <div class="card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                        </svg>
                        Task Information
                    </h2>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                                </svg>
                                Task Name
                            </div>
                            <div class="info-value">{{ $timeLog->task->title }}</div>
                        </div>

                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                                </svg>
                                Project
                            </div>
                            <div class="info-value">
                                <a href="{{ route('admin.projects.show', $timeLog->task->project_id) }}" class="link-item" style="padding: 0;">
                                    {{ $timeLog->task->project->title }}
                                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
                                    </svg>
                                </a>
                            </div>
                        </div>

                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                                Team Member
                            </div>
                            <div class="info-value">{{ $timeLog->admin->name }}</div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Time Details --}}
            <div class="info-card">
                <div class="card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Time Details
                    </h2>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Start Time
                            </div>
                            <div class="info-value">{{ $timeLog->start_time->format('M d, Y h:i A') }}</div>
                        </div>

                        @if($timeLog->end_time)
                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                End Time
                            </div>
                            <div class="info-value">{{ $timeLog->end_time->format('M d, Y h:i A') }}</div>
                        </div>
                        @endif

                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Status
                            </div>
                            <div class="info-value">
                                @if($timeLog->is_running)
                                <span class="status-badge running">
                                    <svg fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM9.555 7.168A1 1 0 008 8v4a1 1 0 001.555.832l3-2a1 1 0 000-1.664l-3-2z" clip-rule="evenodd"/>
                                    </svg>
                                    Running
                                </span>
                                @else
                                <span class="status-badge completed">
                                    <svg fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                    </svg>
                                    Completed
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Sidebar --}}
        <div>
            {{-- Duration Card --}}
            <div class="info-card" style="margin-bottom: var(--space-xl);">
                <div class="card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                        Duration
                    </h2>
                </div>
                <div class="card-body" style="text-align: center;">
                    <div class="info-value-large">{{ $timeLog->formatted_duration }}</div>
                    <div style="font-size: var(--font-sm); color: var(--text-secondary); margin-top: var(--space-sm);">
                        {{ $timeLog->duration_hours }} hours
                    </div>
                </div>
            </div>

            {{-- Billing Info --}}
            @if($timeLog->is_billable)
            <div class="info-card">
                <div class="card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Billing
                    </h2>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">Hourly Rate</div>
                            <div class="info-value">₹{{ number_format($timeLog->hourly_rate, 2) }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Billable Amount</div>
                            <div class="info-value">₹{{ number_format($timeLog->billable_amount, 2) }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Billed Status</div>
                            <div class="info-value">
                                @if($timeLog->is_billed)
                                <span class="status-badge completed">
                                    <svg fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                    </svg>
                                    Billed
                                </span>
                                @else
                                <span class="status-badge running">
                                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                    Unbilled
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>

    {{-- Location Section --}}
    @if($timeLog->has_location)
    <div class="location-card">
        <div class="location-header">
            <h2 class="location-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                Work Location
            </h2>
            <a href="{{ $timeLog->google_maps_url }}" target="_blank" class="btn-map">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
                </svg>
                Open in Google Maps
            </a>
        </div>

        <div class="location-details">
            <div class="location-info">
                {{-- IP Address --}}
                @if($timeLog->ip_address)
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">IP Address</div>
                        <div class="location-text-value">{{ $timeLog->ip_address }}</div>
                    </div>
                </div>
                @endif

                {{-- GPS Coordinates --}}
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">GPS Coordinates</div>
                        <div class="location-text-value">
                            {{ number_format($timeLog->latitude, 6) }}, {{ number_format($timeLog->longitude, 6) }}
                        </div>
                    </div>
                </div>

                {{-- Accuracy --}}
                @if($timeLog->location_accuracy)
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">Accuracy</div>
                        <div class="location-text-value">
                            <span class="accuracy-badge">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                ±{{ round($timeLog->location_accuracy) }} meters
                            </span>
                        </div>
                    </div>
                </div>
                @endif
            </div>

            {{-- Google Maps Embed --}}
            <div class="map-container">
                <iframe 
                    class="map-frame"
                    src="https://www.google.com/maps?q={{ $timeLog->latitude }},{{ $timeLog->longitude }}&z=16&output=embed"
                    loading="lazy"
                    allowfullscreen
                    referrerpolicy="no-referrer-when-downgrade">
                </iframe>
            </div>
        </div>
    </div>
    @else
    {{-- No Location Data --}}
    <div class="no-location-card">
        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>
        <div class="no-location-text">
            <h4>No Location Data Available</h4>
            <p>This time log was created before GPS tracking was enabled, or location permissions were not granted.</p>
        </div>
    </div>
    @endif
</div>