<?php

use Illuminate\Support\Facades\Route;
use Modules\ProjectManagement\Http\Controllers\ProjectController;
use Modules\ProjectManagement\Http\Controllers\TaskController;
use Modules\ProjectManagement\Http\Controllers\TimeLogController;
use Modules\ProjectManagement\Http\Controllers\MilestoneController;
use Modules\ProjectManagement\Http\Controllers\DiscussionController;
use App\Http\Middleware\EnsureIsAdmin;
use Modules\ProjectManagement\Http\Controllers\DashboardController;


// ==================== DASHBOARD ====================
Route::prefix('admin/project-management')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.project-management.')
    ->group(function () {
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('/chart-data', [DashboardController::class, 'chartData'])->name('chart-data');
        Route::get('/refresh-stats', [DashboardController::class, 'refreshStats'])->name('refresh-stats');
    });

// ==================== PROJECTS ====================
Route::prefix('admin/projects')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.projects.')
    ->group(function () {
        // List & Data
        Route::get('/', [ProjectController::class, 'index'])->name('index');
        Route::get('/data', [ProjectController::class, 'dataTable'])->name('data');
        

         Route::get('/stats', [ProjectController::class, 'stats'])->name('stats');
         
        // Bulk Operations
        Route::post('/bulk-delete', [ProjectController::class, 'bulkDelete'])->name('bulk-delete');
        
        // CRUD
        Route::get('/create', [ProjectController::class, 'create'])->name('create');
        Route::post('/', [ProjectController::class, 'store'])->name('store');
        Route::get('/{id}/overview', [ProjectController::class, 'overview'])->name('overview');
        Route::get('/{id}', [ProjectController::class, 'show'])->name('show');
        Route::get('/{id}/edit', [ProjectController::class, 'edit'])->name('edit');
        Route::put('/{id}', [ProjectController::class, 'update'])->name('update');
        Route::delete('/{id}', [ProjectController::class, 'destroy'])->name('destroy');
        
        // Special Actions
        Route::post('/{id}/pin', [ProjectController::class, 'pin'])->name('pin');
        Route::post('/{id}/duplicate', [ProjectController::class, 'duplicate'])->name('duplicate');
        Route::get('/{id}/finance', [ProjectController::class, 'finance'])->name('finance');
        Route::post('/{id}/generate-invoice', [ProjectController::class, 'generateInvoice'])->name('generate-invoice');
    });

// ==================== TASKS ====================
Route::prefix('admin/tasks')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.tasks.')
    ->group(function () {
        // List & Data
        Route::get('/', [TaskController::class, 'index'])->name('index');
        Route::get('/data', [TaskController::class, 'dataTable'])->name('data');
        
        Route::get('/stats', [TaskController::class, 'stats'])->name('stats');

        // Bulk Operations
        Route::post('/bulk-delete', [TaskController::class, 'bulkDelete'])->name('bulk-delete');
        Route::post('/bulk-status', [TaskController::class, 'bulkStatusUpdate'])->name('bulk-status');
        
        // CRUD
        Route::get('/create', [TaskController::class, 'create'])->name('create');
        Route::post('/', [TaskController::class, 'store'])->name('store');
        Route::get('/{id}', [TaskController::class, 'show'])->name('show');
        Route::get('/{id}/edit', [TaskController::class, 'edit'])->name('edit');
        Route::put('/{id}', [TaskController::class, 'update'])->name('update');
        Route::delete('/{id}', [TaskController::class, 'destroy'])->name('destroy');
        
        // ===== TIMER ACTIONS (WITH GPS TRACKING) =====
        Route::post('/{id}/start-timer', [TaskController::class, 'startTimer'])->name('start-timer');
        Route::post('/{id}/pause-timer', [TaskController::class, 'pauseTimer'])->name('pause-timer');
        Route::post('/{id}/resume-timer', [TaskController::class, 'resumeTimer'])->name('resume-timer');
        Route::post('/{id}/stop-timer', [TaskController::class, 'stopTimer'])->name('stop-timer');
        
        // Task Comments & Attachments
        Route::post('/{id}/comment', [TaskController::class, 'addComment'])->name('comment');
        Route::post('/{id}/attach', [TaskController::class, 'attachFile'])->name('attach');
        Route::get('/attachment/{attachmentId}/download', [TaskController::class, 'downloadAttachment'])->name('download-attachment');
        Route::get('/attachment/{attachmentId}/preview', [TaskController::class, 'previewAttachment'])->name('preview-attachment');
        Route::delete('/{id}/attachment/{attachmentId}', [TaskController::class, 'deleteAttachment'])->name('delete-attachment');


    });

// ==================== TIME LOGS (TIMER-ONLY, NO MANUAL ENTRY) ====================
Route::prefix('admin/timelogs')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.timelogs.')
    ->group(function () {
        // List & Data
        Route::get('/', [TimeLogController::class, 'index'])->name('index');
        Route::get('/data', [TimeLogController::class, 'dataTable'])->name('data');

        Route::get('/stats', [TimeLogController::class, 'stats'])->name('stats');
        
        // View Single Time Log (with GPS Map)
        Route::get('/{id}', [TimeLogController::class, 'show'])->name('show');
        
        // Delete Operations
        Route::delete('/{id}', [TimeLogController::class, 'destroy'])->name('destroy');
        Route::post('/bulk-delete', [TimeLogController::class, 'bulkDelete'])->name('bulk-delete');
        
        // ❌ REMOVED: Manual time entry routes (create, store, edit, update)
        // Time logs are now created ONLY via timer in tasks
    });

// ==================== MILESTONES ====================
Route::prefix('admin/milestones')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.milestones.')
    ->group(function () {
        // List & Data
        Route::get('/', [MilestoneController::class, 'index'])->name('index');
        Route::get('/data', [MilestoneController::class, 'dataTable'])->name('data');

        Route::get('/stats', [MilestoneController::class, 'stats'])->name('stats');
        Route::get('/{id}', [MilestoneController::class, 'show'])->name('show');
        // CRUD
        Route::get('/create', [MilestoneController::class, 'create'])->name('create');
        Route::post('/', [MilestoneController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [MilestoneController::class, 'edit'])->name('edit');
        Route::put('/{id}', [MilestoneController::class, 'update'])->name('update');
        Route::delete('/{id}', [MilestoneController::class, 'destroy'])->name('destroy');
        
        // Bulk Operations
        Route::post('/bulk-delete', [MilestoneController::class, 'bulkDelete'])->name('bulk-delete');
    });

// ==================== DISCUSSIONS ====================
Route::prefix('admin/discussions')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.discussions.')
    ->group(function () {
        // List & Data
        Route::get('/', [DiscussionController::class, 'index'])->name('index');
        Route::get('/data', [DiscussionController::class, 'dataTable'])->name('data');

        Route::get('/stats', [DiscussionController::class, 'stats'])->name('stats');
        
        // CRUD
        Route::get('/create', [DiscussionController::class, 'create'])->name('create');
        Route::post('/', [DiscussionController::class, 'store'])->name('store');
        Route::get('/{id}', [DiscussionController::class, 'show'])->name('show');
        Route::delete('/{id}', [DiscussionController::class, 'destroy'])->name('destroy');
        
        // Discussion Actions
        Route::post('/{id}/reply', [DiscussionController::class, 'addReply'])->name('reply');
        Route::delete('/{id}/reply/{replyId}', [DiscussionController::class, 'deleteReply'])->name('delete-reply');
        
        // Bulk Operations
        Route::post('/bulk-delete', [DiscussionController::class, 'bulkDelete'])->name('bulk-delete');
    });