<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('vendor_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vendor_id')->constrained('vendors')->cascadeOnDelete();
            $table->foreignId('product_id')->constrained('products')->cascadeOnDelete();
            $table->unsignedBigInteger('variation_id')->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();
            $table->string('vendor_sku', 100)->nullable()->comment('Vendor specific SKU');
            $table->decimal('purchase_price', 12, 2)->default(0);
            $table->decimal('moq', 10, 3)->default(1)->comment('Minimum Order Quantity');
            $table->integer('lead_days')->default(0)->comment('Lead time in days');
            $table->boolean('is_preferred')->default(false)->comment('Preferred supplier for this item');
            $table->boolean('is_active')->default(true);
            $table->text('notes')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->timestamps();

            // Unique constraint: one product/variation per vendor
            $table->unique(['vendor_id', 'product_id', 'variation_id'], 'vendor_product_variation_unique');
            $table->index(['vendor_id', 'is_active']);
            $table->index(['product_id', 'is_active']);

            // Foreign keys for optional references
            $table->foreign('variation_id')->references('id')->on('product_variations')->nullOnDelete();
            $table->foreign('unit_id')->references('id')->on('units')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vendor_items');
    }
};
