<?php

namespace Modules\Purchase\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use App\Models\Module;

class PurchasePermissionSeeder extends Seeder
{
    public function run(): void
    {
        $guard = 'admin';
        
        // Get or create purchase module
        $module = Module::where('alias', 'purchase')->first();
        $moduleId = $module ? $module->id : null;
        
        // Define all permissions for Purchase module
        $permissions = [
            // Purchase Requests
            'purchase.purchase-requests.read',
            'purchase.purchase-requests.create',
            'purchase.purchase-requests.edit',
            'purchase.purchase-requests.delete',
            'purchase.purchase-requests.approve',
            
            // Purchase Orders
            'purchase.purchase-orders.read',
            'purchase.purchase-orders.create',
            'purchase.purchase-orders.edit',
            'purchase.purchase-orders.delete',
            'purchase.purchase-orders.approve',
            'purchase.purchase-orders.print',
            
            // GRN
            'purchase.grn.read',
            'purchase.grn.create',
            'purchase.grn.edit',
            'purchase.grn.delete',
            'purchase.grn.approve',
            
            // Vendor Bills
            'purchase.vendor-bills.read',
            'purchase.vendor-bills.create',
            'purchase.vendor-bills.edit',
            'purchase.vendor-bills.delete',
            'purchase.vendor-bills.approve',
            'purchase.vendor-bills.print',
            
            // Vendors
            'purchase.vendors.read',
            'purchase.vendors.create',
            'purchase.vendors.edit',
            'purchase.vendors.delete',
            'purchase.vendors.export',
            'purchase.vendors.import',
            
            // Settings
            'purchase.purchase-settings.read',
            'purchase.purchase-settings.edit',
            
            // General module access
            'purchase.read',
        ];
        
        foreach ($permissions as $permissionName) {
            Permission::firstOrCreate(
                ['name' => $permissionName, 'guard_name' => $guard],
                ['module_id' => $moduleId]
            );
        }
        
        // Clear permission cache
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();
        
        $this->command->info('Purchase module permissions created successfully!');
    }
}
