<?php

namespace Modules\Purchase\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;

class RouteServiceProvider extends ServiceProvider
{
    protected string $moduleNamespace = 'Modules\\Purchase\\Http\\Controllers';

    public function boot(): void
    {
        parent::boot();
        
        $this->routes(function () {
            $this->mapWebRoutes();
        });
    }

    protected function mapWebRoutes(): void
    {
        Route::middleware('web')
            ->namespace($this->moduleNamespace)
            ->group(module_path('Purchase', 'Routes/web.php'));
    }
}
