@include('purchase::partials.styles')

<style>
/* ========== GRN CREATE - PROFESSIONAL STYLES ========== */
.grn-page .page-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 24px;
}
.grn-page .page-header h1 {
    font-size: 22px;
    font-weight: 700;
    margin: 0;
}

/* Mode Selection Cards */
.mode-cards {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 16px;
    margin-bottom: 20px;
    max-width: 100%;
    overflow: hidden;
}
.mode-card {
    position: relative;
    display: flex;
    align-items: center;
    gap: 14px;
    padding: 18px 20px;
    border: 2px solid var(--border, #e2e8f0);
    border-radius: 12px;
    cursor: pointer;
    transition: all 0.2s ease;
    background: var(--bg-primary, #fff);
}
.mode-card:hover {
    border-color: var(--primary, #6366f1);
    background: rgba(99, 102, 241, 0.02);
}
.mode-card.active {
    border-color: var(--primary, #6366f1);
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.04), rgba(99, 102, 241, 0.08));
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.12);
}
.mode-card input[type="radio"] {
    display: none;
}
.mode-card .mode-radio {
    width: 22px;
    height: 22px;
    border-radius: 50%;
    border: 2px solid var(--border, #cbd5e1);
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    transition: all 0.2s ease;
}
.mode-card.active .mode-radio {
    border-color: var(--primary, #6366f1);
    background: var(--primary, #6366f1);
}
.mode-card.active .mode-radio::after {
    content: '';
    width: 8px;
    height: 8px;
    border-radius: 50%;
    background: #fff;
}
.mode-card .mode-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    flex-shrink: 0;
}
.mode-card.po-mode .mode-icon {
    background: linear-gradient(135deg, #dbeafe, #bfdbfe);
    color: #2563eb;
}
.mode-card.vendor-mode .mode-icon {
    background: linear-gradient(135deg, #fce7f3, #fbcfe8);
    color: #db2777;
}
.mode-card .mode-info h4 {
    font-size: 15px;
    font-weight: 600;
    margin: 0 0 2px 0;
    color: var(--text-primary, #1e293b);
}
.mode-card .mode-info p {
    font-size: 12px;
    margin: 0;
    color: var(--text-secondary, #64748b);
}

/* Vendor Mode Section */
.vendor-select-row {
    display: flex;
    gap: 12px;
    align-items: flex-end;
}
.vendor-select-row .form-group {
    flex: 1;
}
.vendor-select-row .btn-load-items {
    height: 42px;
    padding: 0 20px;
    display: flex;
    align-items: center;
    gap: 8px;
    white-space: nowrap;
    background: var(--primary, #6366f1);
    color: #fff;
    border: none;
    border-radius: 8px;
    font-weight: 500;
    font-size: 13px;
    cursor: pointer;
    transition: all 0.2s ease;
}
.vendor-select-row .btn-load-items:hover {
    background: var(--primary-hover, #4f46e5);
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}
.vendor-select-row .btn-load-items svg {
    width: 16px;
    height: 16px;
}

/* Enhanced Items Table */
.items-table-wrapper {
    overflow-x: auto;
    margin: 0;
}
.items-table {
    width: 100%;
    border-collapse: collapse;
  font-size: 12px;
}
.items-table thead {
    background: var(--bg-secondary, #f8fafc);
    position: sticky;
    top: 0;
    z-index: 1;
}
.items-table thead th {
    padding: 6px 8px;
    font-size: 10px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: var(--text-secondary, #64748b);
    border-bottom: 2px solid var(--border, #e2e8f0);
    white-space: nowrap;
    text-align: left;
}
.items-table tbody td {
   padding: 6px 8px;
    border-bottom: 1px solid var(--border, #f1f5f9);
   vertical-align: middle;
}
.items-table tbody tr:hover {
    background: rgba(99, 102, 241, 0.02);
}

/* Product Info Cell */
.product-cell {
    min-width: 160px;
}
.product-cell .product-name {
    font-weight: 600;
    color: var(--text-primary, #1e293b);
    font-size: 12px;
    display: block;
    margin-bottom: 2px;
}
.product-cell .product-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 4px;
    align-items: center;
}
.product-cell .meta-badge {
    display: inline-flex;
    align-items: center;
  padding: 1px 5px;
    border-radius: 4px;
    font-size: 10px;
    font-weight: 500;
}
.meta-badge.sku {
    background: #f1f5f9;
    color: #475569;
}
.meta-badge.variation {
    background: #8b5cf6;
    color: #fff;
}
.meta-badge.unit {
    background: #ecfdf5;
    color: #059669;
}
.meta-badge.hsn {
    background: #fef3c7;
    color: #92400e;
}

/* Price Cells */
.price-cell {
    min-width: 100px;
}
.price-cell input {
    width: 100px;
    text-align: right;
}

/* GST Cell */
.gst-cell {
    min-width: 130px;
}
.gst-cell select {
    font-size: 12px;
    padding: 6px 8px;
}

/* Qty Cells */
.qty-cell {
    min-width: 90px;
}
.qty-cell input {
    width: 90px;
    text-align: center; 
}
.qty-cell .qty-info {
    font-size: 11px;
    color: var(--text-secondary, #94a3b8);
    text-align: center;
    margin-top: 4px;
}

/* Batch Fields */
.batch-toggle {
    display: flex;
    align-items: center;
    gap: 6px;
   font-size: 11px;
    color: var(--primary, #6366f1);
    cursor: pointer;
    padding: 4px 0;
}
.batch-toggle:hover {
    text-decoration: underline;
}
.batch-fields-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 6px;
    margin-top: 6px;
}
.batch-fields-grid .form-group {
    margin-bottom: 0;
}
.batch-fields-grid .form-label {
    font-size: 9px;
    margin-bottom: 2px;
}
.batch-fields-grid .form-control {
    font-size: 10px;
    padding: 4px 8px;
    height: 26px;
}

/* Summary Card */
.summary-card {
    position: static;
}
.summary-card .summary-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 0;
    border-bottom: 1px solid var(--border, #f1f5f9);
}
.summary-card .summary-row:last-child {
    border-bottom: none;
}
.summary-card .summary-label {
    font-size: 13px;
    color: var(--text-secondary, #64748b);
}
.summary-card .summary-value {
    font-size: 15px;
    font-weight: 700;
    color: var(--text-primary, #1e293b);
}
.summary-card .summary-value.success { color: #059669; }
.summary-card .summary-value.danger { color: #dc2626; }

/* Form Actions - Sidebar */
.sidebar-actions {
    display: flex;
    flex-direction: column;
    gap: 10px;
    margin-top: 16px;
}
.sidebar-actions .btn {
    width: 100%;
    justify-content: center;
    padding: 12px 16px;
    font-weight: 600;
    border-radius: 10px;
    display: flex;
    align-items: center;
    gap: 8px;
}

/* Shared submit button styles */
.submit-btn {
    background: linear-gradient(135deg, var(--primary, #6366f1), #4f46e5) !important;
    box-shadow: 0 4px 14px rgba(99, 102, 241, 0.35);
    color: #fff !important;
    border: none !important;
    cursor: pointer;
    transition: all 0.2s ease;
}
.submit-btn:hover:not(:disabled) {
    transform: translateY(-1px);
    box-shadow: 0 6px 20px rgba(99, 102, 241, 0.45);
}
.submit-btn:disabled {
    opacity: 0.5;
    transform: none !important;
    box-shadow: none !important;
    cursor: not-allowed;
}

/* Bottom Actions */
.bottom-actions {
    display: flex;
    gap: 12px;
    margin-top: 12px;
    padding: 20px 0;
}
.bottom-actions .btn {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 14px 24px;
    font-weight: 600;
    border-radius: 10px;
    font-size: 14px;
}
.bottom-actions .submit-btn {
    flex: 1;
}

/* Empty State */
.empty-state-box {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 60px 24px;
    text-align: center;
}
.empty-state-box svg {
    width: 64px;
    height: 64px;
    opacity: 0.3;
    margin-bottom: 16px;
}
.empty-state-box h4 {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary, #1e293b);
    margin: 0 0 6px 0;
}
.empty-state-box p {
    font-size: 13px;
    color: var(--text-secondary, #94a3b8);
    margin: 0;
}

/* Row number */
.row-num {
    width: 28px;
    height: 28px;
    border-radius: 6px;
    background: var(--bg-secondary, #f1f5f9);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 11px;
    font-weight: 600;
    color: var(--text-secondary, #64748b);
}

/* Responsive */
@media (max-width: 1200px) {
    .main-layout {
        grid-template-columns: 1fr !important;
    }
    .summary-card {
        position: static;
    }
}
</style>

<div class="grn-page">
    <div class="page-header">
        <h1>Create Goods Receipt Note</h1>
        <a href="{{ route('admin.purchase.grn.index') }}" class="btn btn-outline">← Back</a>
    </div>

    @if($errors->any())
    <div class="alert alert-danger" style="margin-bottom: 20px;">
        <strong>⚠ Validation Error:</strong>
        <ul style="margin: 8px 0 0 0; padding-left: 20px;">
            @foreach($errors->all() as $error)<li>{{ $error }}</li>@endforeach
        </ul>
    </div>
    @endif

    <div class="alert alert-info" style="margin-bottom: 24px;">
        <strong>💡 Workflow:</strong> Select PO or Vendor → Enter received quantities → Save Draft → Submit for Inspection → Approve to update stock
    </div>

    <form action="{{ route('admin.purchase.grn.store') }}" method="POST" id="grnForm">
        @csrf
        <input type="hidden" name="receipt_mode" id="receiptMode" value="po">
        
        <div class="main-layout" style="display: grid; grid-template-columns: minmax(0, 1fr) 280px; gap: 20px;">
            <!-- Left Column -->
            <div style="min-width: 0;">
                <!-- ========== RECEIPT MODE ========== -->
                <div class="card">
                    <div class="card-header"><h5>Receipt Mode</h5></div>
                    <div class="card-body">
                        <div class="mode-cards">
                            <label class="mode-card po-mode active" id="modePOCard" onclick="switchMode('po')">
                                <input type="radio" name="mode_selector" value="po" checked>
                                <span class="mode-radio"></span>
                                <span class="mode-icon">📋</span>
                                <div class="mode-info">
                                    <h4>From Purchase Order</h4>
                                    <p>Receive items against an existing PO</p>
                                </div>
                            </label>
                            <label class="mode-card vendor-mode" id="modeVendorCard" onclick="switchMode('vendor')">
                                <input type="radio" name="mode_selector" value="vendor">
                                <span class="mode-radio"></span>
                                <span class="mode-icon">🏢</span>
                                <div class="mode-info">
                                    <h4>Direct from Vendor</h4>
                                    <p>Receive items directly without a PO</p>
                                </div>
                            </label>
                        </div>

                        <!-- PO Selection -->
                        <div id="poModeSection">
                            <div class="form-row">
                                <div class="form-group" style="flex:2;">
                                    <label class="form-label">Purchase Order <span class="required">*</span></label>
                                    <select name="purchase_order_id" id="poSelect" class="form-control">
                                        <option value="">-- Select Confirmed PO --</option>
                                        @foreach($purchaseOrders as $po)
                                        <option value="{{ $po->id }}" 
                                            data-vendor="{{ $po->vendor_id }}" 
                                            data-vendor-name="{{ $po->vendor->name ?? 'N/A' }}"
                                            {{ (request('po_id') == $po->id || old('purchase_order_id') == $po->id) ? 'selected' : '' }}>
                                            {{ $po->po_number }} - {{ $po->vendor->name ?? 'N/A' }} ({{ $po->po_date->format('d M Y') }})
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group" style="flex:1;">
                                    <label class="form-label">Vendor</label>
                                    <input type="text" id="vendorDisplay" class="form-control" readonly placeholder="Auto-filled from PO">
                                </div>
                            </div>
                        </div>

                        <!-- Vendor Selection -->
                        <div id="vendorModeSection" style="display:none;">
                            <div class="vendor-select-row">
                                <div class="form-group">
                                    <label class="form-label">Select Vendor <span class="required">*</span></label>
                                    <select name="direct_vendor_id" id="vendorSelect" class="form-control">
                                        <option value="">-- Select Vendor --</option>
                                        @foreach($vendors as $v)
                                        <option value="{{ $v->id }}">{{ $v->vendor_code }} - {{ $v->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="button" class="btn-load-items" id="loadVendorItemsBtn" onclick="loadVendorItems()">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.66 0 3-4.03 3-9s-1.34-9-3-9m0 18c-1.66 0-3-4.03-3-9s1.34-9 3-9"/></svg>
                                    Load Items
                                </button>
                            </div>
                        </div>

                        <input type="hidden" name="vendor_id" id="vendorId">
                    </div>
                </div>

                <!-- ========== RECEIPT DETAILS ========== -->
                <div class="card">
                    <div class="card-header"><h5>Receipt Details</h5></div>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="form-group">
                                <label class="form-label">GRN Date <span class="required">*</span></label>
                                <input type="date" name="grn_date" class="form-control" value="{{ old('grn_date', date('Y-m-d')) }}" required>
                            </div>
                            <div class="form-group">
                                <label class="form-label">Warehouse <span class="required">*</span></label>
                                <select name="warehouse_id" id="warehouseSelect" class="form-control" required>
                                    <option value="">-- Select Warehouse --</option>
                                    @foreach($warehouses as $wh)
                                    <option value="{{ $wh->id }}" {{ old('warehouse_id') == $wh->id ? 'selected' : '' }}>{{ $wh->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="form-label">Rack/Location</label>
                                <select name="rack_id" id="rackSelect" class="form-control">
                                    <option value="">-- Optional --</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="form-label">Received By</label>
                                <input type="text" name="received_by_name" class="form-control" value="{{ old('received_by_name', auth()->user()->name ?? '') }}" readonly>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label class="form-label">Vendor Invoice No</label>
                                <input type="text" name="invoice_number" class="form-control" value="{{ old('invoice_number') }}" placeholder="e.g. INV-001">
                            </div>
                            <div class="form-group">
                                <label class="form-label">Invoice Date</label>
                                <input type="date" name="invoice_date" class="form-control" value="{{ old('invoice_date') }}">
                            </div>
                            <div class="form-group">
                                <label class="form-label">LR/Docket No</label>
                                <input type="text" name="lr_number" class="form-control" value="{{ old('lr_number') }}" placeholder="Transport ref">
                            </div>
                            <div class="form-group">
                                <label class="form-label">Vehicle Number</label>
                                <input type="text" name="vehicle_number" class="form-control" value="{{ old('vehicle_number') }}" style="text-transform:uppercase;" placeholder="e.g. KA01AB1234">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ========== RECEIVED ITEMS ========== -->
                <div class="card">
                    <div class="card-header" style="display:flex;align-items:center;justify-content:space-between;">
                        <h5>Received Items</h5>
                        <span class="badge badge-info" id="itemCount">0 Items</span>
                    </div>
                    <div class="card-body" style="padding: 0;">
                        <div id="itemsContainer">
                            <!-- Empty State -->
                            <div class="empty-state-box" id="emptyState">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                                    <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/>
                                    <polyline points="3.27 6.96 12 12.01 20.73 6.96"/>
                                    <line x1="12" y1="22.08" x2="12" y2="12"/>
                                </svg>
                                <h4>No Items to Receive</h4>
                                <p>Select a Purchase Order or Vendor above to load items</p>
                            </div>

                            <!-- Loading State -->
                            <div class="empty-state-box" id="loadingState" style="display: none;">
                                <div class="spinner" style="width:32px;height:32px;border:3px solid var(--border);border-top-color:var(--primary);border-radius:50%;animation:spin 0.8s linear infinite;margin-bottom:12px;"></div>
                                <p>Loading items...</p>
                            </div>

                            <!-- Items Table -->
                            <div class="items-table-wrapper">
                                <table class="items-table" id="itemsTable" style="display: none;">
                                    <thead>
                                        <tr>
                                            <th style="width:36px;">#</th>
                                            <th style="min-width:200px;">Product</th>
                                            <th class="col-ordered" id="colOrdered">Ordered</th>
                                            <th class="col-prev-rcvd" id="colPrevRcvd">Prev Rcvd</th>
                                            <th>HSN Code</th>
                                            <th>Purchase Price</th>
                                            <th>Selling Price</th>
                                            <th>MRP</th>
                                            <th>GST %</th>
                                            <th>Received Qty</th>
                                            <th>Accepted Qty</th>
                                            <th>Rejected Qty</th>
                                            <th style="min-width:240px;">Lot/Batch</th>
                                        </tr>
                                    </thead>
                                    <tbody id="itemsBody"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ========== NOTES ========== -->
                <div class="card">
                    <div class="card-header"><h5>Notes</h5></div>
                    <div class="card-body">
                        <textarea name="notes" class="form-control" rows="3" placeholder="Any remarks or special instructions...">{{ old('notes') }}</textarea>
                    </div>
                </div>

                <!-- ========== BOTTOM ACTIONS ========== -->
                <div class="bottom-actions">
                    <button type="submit" class="btn submit-btn" disabled>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 8 15 8"/></svg>
                        Save as Draft
                    </button>
                    <a href="{{ route('admin.purchase.grn.index') }}" class="btn btn-outline" style="padding:14px 28px;border-radius:10px;">Cancel</a>
                </div>
            </div>

            <!-- ========== RIGHT SIDEBAR ========== -->
          <div style="position: sticky; top: 16px; align-self: start;">
                <div class="card summary-card">
                    <div class="card-header"><h5>Summary</h5></div>
                    <div class="card-body">
                        <div class="summary-row">
                            <span class="summary-label">Total Items</span>
                            <span class="summary-value" id="summaryItems">0</span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Total Received</span>
                            <span class="summary-value" id="summaryReceived">0</span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Total Accepted</span>
                            <span class="summary-value success" id="summaryAccepted">0</span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Total Rejected</span>
                            <span class="summary-value danger" id="summaryRejected">0</span>
                        </div>
                        <div class="summary-row" style="border-top:2px solid var(--border);padding-top:12px;margin-top:4px;">
                            <span class="summary-label" style="font-weight:600;">Total Value</span>
                            <span class="summary-value" id="summaryValue" style="color:var(--primary);">₹0.00</span>
                        </div>
                    </div>
                </div>

                <div class="sidebar-actions">
                    <button type="submit" class="btn btn-primary submit-btn" disabled>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 8 15 8"/></svg>
                        Save as Draft
                    </button>
                    <a href="{{ route('admin.purchase.grn.index') }}" class="btn btn-outline" style="justify-content:center;">Cancel</a>
                </div>
            </div>
        </div>
    </form>
</div>

<style>
@keyframes spin { to { transform: rotate(360deg); } }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const poSelect = document.getElementById('poSelect');
    const warehouseSelect = document.getElementById('warehouseSelect');
    const rackSelect = document.getElementById('rackSelect');
    const vendorDisplay = document.getElementById('vendorDisplay');
    const vendorId = document.getElementById('vendorId');
    const vendorSelect = document.getElementById('vendorSelect');
    const itemsBody = document.getElementById('itemsBody');
    const itemsTable = document.getElementById('itemsTable');
    const emptyState = document.getElementById('emptyState');
    const loadingState = document.getElementById('loadingState');
    let currentMode = 'po';

    // Sync all submit buttons (sidebar + bottom)
    function setSubmitDisabled(disabled) {
        document.querySelectorAll('.submit-btn').forEach(btn => btn.disabled = disabled);
    }

    // GST Options
    const gstOptions = [
        { value: '0', label: 'GST 0%' },
        { value: '5', label: 'GST 5%' },
        { value: '12', label: 'GST 12%' },
        { value: '18', label: 'GST 18%' },
        { value: '28', label: 'GST 28%' },
    ];

    function getGstSelect(name, selectedValue) {
        let html = `<select name="${name}" class="form-control gst-select" style="font-size:12px;padding:6px 8px;min-width:100px;">`;
        html += `<option value="">-- GST --</option>`;
        gstOptions.forEach(opt => {
            const sel = (selectedValue && parseFloat(selectedValue) === parseFloat(opt.value)) ? 'selected' : '';
            html += `<option value="${opt.value}" ${sel}>${opt.label}</option>`;
        });
        html += `</select>`;
        return html;
    }

    // ========== MODE SWITCHING ==========
    window.switchMode = function(mode) {
        currentMode = mode;
        document.getElementById('receiptMode').value = mode;
        
        const poSection = document.getElementById('poModeSection');
        const vendorSection = document.getElementById('vendorModeSection');
        const modePOCard = document.getElementById('modePOCard');
        const modeVendorCard = document.getElementById('modeVendorCard');
        
        if (mode === 'po') {
            poSection.style.display = 'block';
            vendorSection.style.display = 'none';
            modePOCard.classList.add('active');
            modeVendorCard.classList.remove('active');
            document.querySelectorAll('.col-ordered, #colOrdered').forEach(el => el.style.display = '');
            document.querySelectorAll('.col-prev-rcvd, #colPrevRcvd').forEach(el => el.style.display = '');
            vendorSelect.value = '';
        } else {
            poSection.style.display = 'none';
            vendorSection.style.display = 'flex';
            modeVendorCard.classList.add('active');
            modePOCard.classList.remove('active');
            document.querySelectorAll('.col-ordered, #colOrdered').forEach(el => el.style.display = 'none');
            document.querySelectorAll('.col-prev-rcvd, #colPrevRcvd').forEach(el => el.style.display = 'none');
            poSelect.value = '';
            vendorDisplay.value = '';
        }
        
        showEmpty();
    };

    // ========== PO MODE ==========
    poSelect.addEventListener('change', function() {
        const selected = this.options[this.selectedIndex];
        vendorDisplay.value = selected.dataset.vendorName || '';
        vendorId.value = selected.dataset.vendor || '';
        if (this.value) loadPOItems(this.value);
        else showEmpty();
    });
    
    warehouseSelect.addEventListener('change', function() {
        if (this.value) loadRacks(this.value);
        else rackSelect.innerHTML = '<option value="">-- Optional --</option>';
    });
    
    function loadPOItems(poId) {
        emptyState.style.display = 'none';
        itemsTable.style.display = 'none';
        loadingState.style.display = 'flex';
        
        fetch(`{{ url('admin/purchase/grn/po-items') }}/${poId}`)
            .then(r => r.json())
            .then(data => {
                loadingState.style.display = 'none';
                if (data.items && data.items.length > 0) {
                    renderPOItems(data.items);
                    itemsTable.style.display = 'table';
                    setSubmitDisabled(false);
                } else {
                    emptyState.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" style="width:64px;height:64px;margin-bottom:16px;opacity:0.3;"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg><h4>All Items Received</h4><p>This PO has no pending items to receive</p>';
                    emptyState.style.display = 'flex';
                    setSubmitDisabled(true);
                }
                updateSummary();
            })
            .catch(err => {
                loadingState.style.display = 'none';
                emptyState.innerHTML = '<h4 style="color:#dc2626;">Error Loading Items</h4><p>' + err.message + '</p>';
                emptyState.style.display = 'flex';
            });
    }

    // ========== VENDOR MODE ==========
    window.loadVendorItems = function() {
        const vId = vendorSelect.value;
        if (!vId) {
            alert('Please select a vendor first.');
            return;
        }
        
        vendorId.value = vId;
        emptyState.style.display = 'none';
        itemsTable.style.display = 'none';
        loadingState.style.display = 'flex';
        
        fetch(`{{ url('admin/purchase/vendors/items') }}/${vId}`)
            .then(r => r.json())
            .then(data => {
                loadingState.style.display = 'none';
                if (data.items && data.items.length > 0) {
                    renderVendorItems(data.items);
                    itemsTable.style.display = 'table';
                    setSubmitDisabled(false);
                } else {
                    emptyState.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" style="width:64px;height:64px;margin-bottom:16px;opacity:0.3;"><path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/></svg><h4>No Items Found</h4><p>This vendor has no active items. Add items in Vendor settings first.</p>';
                    emptyState.style.display = 'flex';
                    setSubmitDisabled(true);
                }
                updateSummary();
            })
            .catch(err => {
                loadingState.style.display = 'none';
                emptyState.innerHTML = '<h4 style="color:#dc2626;">Error Loading Items</h4><p>' + err.message + '</p>';
                emptyState.style.display = 'flex';
            });
    };
    
    function loadRacks(warehouseId) {
        fetch(`{{ url('admin/purchase/grn/racks') }}/${warehouseId}`)
            .then(r => r.json())
            .then(data => {
                rackSelect.innerHTML = '<option value="">-- Optional --</option>';
                data.racks.forEach(rack => {
                    rackSelect.innerHTML += `<option value="${rack.id}">${rack.code ? rack.code + ' - ' : ''}${rack.name}</option>`;
                });
            });
    }
    
    // ========== RENDER PO ITEMS ==========
    function renderPOItems(items) {
        itemsBody.innerHTML = '';
        items.forEach((item, idx) => {
            const pending = item.ordered_qty - item.received_qty;
            const hasBatch = item.product && item.product.is_batch_managed;
            const variationName = item.variation ? (item.variation.variation_name || item.variation.sku || '') : '';
            const productName = item.product?.name || 'N/A';
            const sku = item.product?.sku || '-';
            const unitName = item.unit?.short_name || item.unit?.name || '-';
            const hsnCode = item.product?.hsn_code || item.hsn_code || '';
            const purchasePrice = item.rate || item.product?.purchase_price || 0;
            const sellingPrice = item.product?.sale_price || item.selling_price || '';
            const mrp = item.product?.mrp || item.mrp || '';
            const gstRate = item.product?.tax_rate ?? item.tax_rate ?? '';
            
            itemsBody.innerHTML += `
                <tr>
                    <td><span class="row-num">${idx + 1}</span></td>
                    <td class="product-cell">
                        <span class="product-name">${productName}</span>
                        <div class="product-meta">
                            <span class="meta-badge sku">SKU: ${sku}</span>
                            ${variationName ? `<span class="meta-badge variation">${variationName}</span>` : ''}
                            <span class="meta-badge unit">${unitName}</span>
                        </div>
                        <input type="hidden" name="items[${idx}][po_item_id]" value="${item.id}">
                        <input type="hidden" name="items[${idx}][product_id]" value="${item.product_id}">
                        <input type="hidden" name="items[${idx}][variation_id]" value="${item.variation_id || ''}">
                        <input type="hidden" name="items[${idx}][unit_id]" value="${item.unit_id || ''}">
                    </td>
                    <td class="col-ordered">
                        <div class="qty-cell">
                            <strong>${parseFloat(item.ordered_qty).toFixed(2)}</strong>
                        </div>
                    </td>
                    <td class="col-prev-rcvd">
                        <div class="qty-cell">
                            <strong>${parseFloat(item.received_qty).toFixed(2)}</strong>
                        </div>
                    </td>
                    <td>
                        <input type="text" name="items[${idx}][hsn_code]" class="form-control" value="${item.product?.hsn_code || ''}" placeholder="HSN">
                    </td>
                    <td class="price-cell">
                        <input type="number" name="items[${idx}][rate]" class="form-control purchase-price" value="${purchasePrice}" min="0" step="0.01" data-idx="${idx}" style="font-size:12px;">
                    </td>
                    <td class="price-cell">
                        <input type="number" name="items[${idx}][selling_price]" class="form-control" value="${sellingPrice}" min="0" step="0.01" placeholder="0.00" style="font-size:12px;">
                    </td>
                    <td class="price-cell">
                        <input type="number" name="items[${idx}][mrp]" class="form-control" value="${mrp}" min="0" step="0.01" placeholder="0.00" style="font-size:12px;">
                    </td>
                    <td class="gst-cell">
                        ${getGstSelect('items[' + idx + '][gst_rate]', gstRate)}
                    </td>
                    <td class="qty-cell">
                        <input type="number" name="items[${idx}][received_qty]" class="form-control received-qty" value="${pending}" min="0" max="${pending}" step="0.01" data-idx="${idx}">
                        <div class="qty-info">Pending: ${pending.toFixed(2)}</div>
                    </td>
                    <td class="qty-cell">
                        <input type="number" name="items[${idx}][accepted_qty]" class="form-control accepted-qty" value="${pending}" min="0" step="0.01" data-idx="${idx}">
                    </td>
                    <td class="qty-cell">
                        <input type="number" name="items[${idx}][rejected_qty]" class="form-control rejected-qty" value="0" min="0" step="0.01" data-idx="${idx}" readonly style="background:#fef2f2;color:#dc2626;">
                    </td>
                    <td>
                        ${hasBatch ? `
                        <div class="batch-toggle" onclick="toggleBatch(this)">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 5v14M5 12h14"/></svg>
                            Add Lot/Batch
                        </div>
                        <div class="batch-fields-grid" style="display:none;">
                            <div class="form-group"><label class="form-label">Lot No</label><input type="text" name="items[${idx}][lot_no]" class="form-control" placeholder="LOT-001"></div>
                            <div class="form-group"><label class="form-label">Batch No</label><input type="text" name="items[${idx}][batch_no]" class="form-control" placeholder="BATCH-001"></div>
                            <div class="form-group"><label class="form-label">Mfg Date</label><input type="date" name="items[${idx}][manufacturing_date]" class="form-control"></div>
                            <div class="form-group"><label class="form-label">Expiry</label><input type="date" name="items[${idx}][expiry_date]" class="form-control"></div>
                        </div>` : '<span style="font-size:11px;color:#94a3b8;">N/A</span>'}</td>
                </tr>`;
        });
        
        document.getElementById('itemCount').textContent = items.length + ' Items';
        bindQtyEvents();
        updateSummary();
    }

    // ========== RENDER VENDOR ITEMS ==========
    function renderVendorItems(items) {
        itemsBody.innerHTML = '';
        items.forEach((item, idx) => {
            const hasBatch = item.product && item.product.is_batch_managed;
            const variationName = item.variation ? (item.variation.variation_name || item.variation.sku || '') : '';
            const productName = item.product?.name || 'N/A';
            const sku = item.product?.sku || '-';
            const unitName = item.unit?.short_name || item.unit?.name || '-';
            const hsnCode = item.product?.hsn_code || item.hsn_code || '';
            const purchasePrice = item.purchase_price || item.product?.purchase_price || 0;
            const sellingPrice = item.product?.sale_price || item.selling_price || '';
            const mrp = item.product?.mrp || item.mrp || '';
            const gstRate = item.product?.tax_rate ?? item.tax_rate ?? '';
            
            itemsBody.innerHTML += `
                <tr>
                    <td><span class="row-num">${idx + 1}</span></td>
                    <td class="product-cell">
                        <span class="product-name">${productName}</span>
                        <div class="product-meta">
                            <span class="meta-badge sku">SKU: ${sku}</span>
                            ${variationName ? `<span class="meta-badge variation">${variationName}</span>` : ''}
                            <span class="meta-badge unit">${unitName}</span>
                            ${item.vendor_sku ? `<span class="meta-badge hsn">V-SKU: ${item.vendor_sku}</span>` : ''}
                        </div>
                        <input type="hidden" name="items[${idx}][vendor_item_id]" value="${item.vendor_item_id}">
                        <input type="hidden" name="items[${idx}][product_id]" value="${item.product_id}">
                        <input type="hidden" name="items[${idx}][variation_id]" value="${item.variation_id || ''}">
                        <input type="hidden" name="items[${idx}][unit_id]" value="${item.unit_id || ''}">
                    </td>
                    <td class="col-ordered" style="display:none;"></td>
                    <td class="col-prev-rcvd" style="display:none;"></td>
                    <td>
                        <input type="text" name="items[${idx}][hsn_code]" class="form-control" value="${hsnCode}" placeholder="HSN" style="width:100px;font-size:12px;">
                    </td>
                    <td class="price-cell">
                        <input type="number" name="items[${idx}][rate]" class="form-control purchase-price" value="${purchasePrice}" min="0" step="0.01" data-idx="${idx}" style="font-size:12px;">
                    </td>
                    <td class="price-cell">
                        <input type="number" name="items[${idx}][selling_price]" class="form-control" value="${sellingPrice}" min="0" step="0.01" placeholder="0.00" style="font-size:12px;">
                    </td>
                    <td class="price-cell">
                        <input type="number" name="items[${idx}][mrp]" class="form-control" value="${mrp}" min="0" step="0.01" placeholder="0.00" style="font-size:12px;">
                    </td>
                    <td class="gst-cell">
                        ${getGstSelect('items[' + idx + '][gst_rate]', gstRate)}
                    </td>
                    <td class="qty-cell">
                        <input type="number" name="items[${idx}][received_qty]" class="form-control received-qty" value="0" min="0" step="0.01" data-idx="${idx}" placeholder="Qty">
                    </td>
                    <td class="qty-cell">
                        <input type="number" name="items[${idx}][accepted_qty]" class="form-control accepted-qty" value="0" min="0" step="0.01" data-idx="${idx}" placeholder="Qty">
                    </td>
                    <td class="qty-cell">
                        <input type="number" name="items[${idx}][rejected_qty]" class="form-control rejected-qty" value="0" min="0" step="0.01" data-idx="${idx}" readonly style="background:#fef2f2;color:#dc2626;">
                    </td>
                    <td>
                        ${hasBatch ? `
                        <div class="batch-toggle" onclick="toggleBatch(this)">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 5v14M5 12h14"/></svg>
                            Add Lot/Batch
                        </div>
                        <div class="batch-fields-grid" style="display:none;">
                            <div class="form-group"><label class="form-label">Lot No</label><input type="text" name="items[${idx}][lot_no]" class="form-control" placeholder="LOT-001"></div>
                            <div class="form-group"><label class="form-label">Batch No</label><input type="text" name="items[${idx}][batch_no]" class="form-control" placeholder="BATCH-001"></div>
                            <div class="form-group"><label class="form-label">Mfg Date</label><input type="date" name="items[${idx}][manufacturing_date]" class="form-control"></div>
                            <div class="form-group"><label class="form-label">Expiry</label><input type="date" name="items[${idx}][expiry_date]" class="form-control"></div>
                        </div>` : '<span style="font-size:11px;color:#94a3b8;">N/A</span>'}</td>
                </tr>`;
        });
        
        document.getElementById('itemCount').textContent = items.length + ' Items';
        bindQtyEvents();
        updateSummary();
    }

    // ========== SHARED FUNCTIONS ==========
    window.toggleBatch = function(el) {
        const fields = el.nextElementSibling;
        if (fields.style.display === 'none') {
            fields.style.display = 'grid';
            el.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M5 12h14"/></svg> Hide Lot/Batch';
        } else {
            fields.style.display = 'none';
            el.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 5v14M5 12h14"/></svg> Add Lot/Batch';
        }
    };

    function bindQtyEvents() {
        document.querySelectorAll('.received-qty, .accepted-qty').forEach(input => {
            input.addEventListener('input', function() {
                const idx = this.dataset.idx;
                const rcv = parseFloat(document.querySelector(`.received-qty[data-idx="${idx}"]`).value) || 0;
                const accInput = document.querySelector(`.accepted-qty[data-idx="${idx}"]`);
                let acc = parseFloat(accInput.value) || 0;
                if (acc > rcv) {
                    acc = rcv;
                    accInput.value = rcv;
                }
                document.querySelector(`.rejected-qty[data-idx="${idx}"]`).value = Math.max(0, rcv - acc).toFixed(2);
                updateSummary();
            });
        });

        // Purchase price change updates summary
        document.querySelectorAll('.purchase-price').forEach(input => {
            input.addEventListener('input', updateSummary);
        });
    }
    
    function showEmpty() {
        itemsTable.style.display = 'none';
        loadingState.style.display = 'none';
        emptyState.innerHTML = `
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" style="width:64px;height:64px;margin-bottom:16px;opacity:0.3;">
                <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/>
                <polyline points="3.27 6.96 12 12.01 20.73 6.96"/>
                <line x1="12" y1="22.08" x2="12" y2="12"/>
            </svg>
            <h4>No Items to Receive</h4>
            <p>Select a Purchase Order or Vendor above to load items</p>`;
        emptyState.style.display = 'flex';
        setSubmitDisabled(true);
        document.getElementById('itemCount').textContent = '0 Items';
        updateSummary();
    }
    
    function updateSummary() {
        let items = document.querySelectorAll('#itemsBody tr').length;
        let rcv = 0, acc = 0, rej = 0, totalValue = 0;
        
        document.querySelectorAll('.received-qty').forEach(i => rcv += parseFloat(i.value) || 0);
        document.querySelectorAll('.accepted-qty').forEach(i => acc += parseFloat(i.value) || 0);
        document.querySelectorAll('.rejected-qty').forEach(i => rej += parseFloat(i.value) || 0);
        
        // Calculate total value (accepted_qty * purchase_price)
        document.querySelectorAll('#itemsBody tr').forEach(row => {
            const accQty = parseFloat(row.querySelector('.accepted-qty')?.value) || 0;
            const price = parseFloat(row.querySelector('.purchase-price')?.value) || 0;
            totalValue += accQty * price;
        });
        
        document.getElementById('summaryItems').textContent = items;
        document.getElementById('summaryReceived').textContent = rcv.toFixed(2);
        document.getElementById('summaryAccepted').textContent = acc.toFixed(2);
        document.getElementById('summaryRejected').textContent = rej.toFixed(2);
        document.getElementById('summaryValue').textContent = '₹' + totalValue.toLocaleString('en-IN', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    }
    
    // Auto-trigger on page load
    if (poSelect.value) poSelect.dispatchEvent(new Event('change'));
    if (warehouseSelect.value) loadRacks(warehouseSelect.value);
    
    // Vehicle number uppercase
    document.querySelector('[name="vehicle_number"]')?.addEventListener('input', function() { 
        this.value = this.value.toUpperCase(); 
    });
});
</script>