@include('purchase::partials.styles')

<div style="padding: 20px;">
    <div class="page-header">
        <h1>Goods Receipt Notes</h1>
        <a href="{{ route('admin.purchase.grn.create') }}" class="btn-add">+ Create GRN</a>
    </div>

    @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon total">📦</div>
            <div><div class="stat-value">{{ $stats['total'] }}</div><div class="stat-label">Total GRN</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon draft">📝</div>
            <div><div class="stat-value">{{ $stats['draft'] }}</div><div class="stat-label">Draft</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon inspecting">🔍</div>
            <div><div class="stat-value">{{ $stats['inspecting'] }}</div><div class="stat-label">Inspecting</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon approved">✅</div>
            <div><div class="stat-value">{{ $stats['approved'] }}</div><div class="stat-label">Approved</div></div>
        </div>
    </div>

    <div class="table-card">
        <div class="table-card-header">
            <div class="table-card-title">GRN List</div>
            <div class="filter-group" style="display:flex; gap:10px; flex-wrap:wrap; align-items:center;">
                <!-- Date Filters -->
                <div class="date-filter-group">
                    <label class="date-filter-label">From</label>
                    <input type="date" id="grnFilterFromDate" class="filter-date">
                </div>
                <div class="date-filter-group">
                    <label class="date-filter-label">To</label>
                    <input type="date" id="grnFilterToDate" class="filter-date">
                </div>

                <!-- Dropdown Filters -->
                <select class="filter-select" data-dt-filter="status" data-dt-table="grnTable">
                    <option value="">All Status</option>
                    <option value="DRAFT">Draft</option>
                    <option value="INSPECTING">Inspecting</option>
                    <option value="APPROVED">Approved</option>
                    <option value="REJECTED">Rejected</option>
                    <option value="CANCELLED">Cancelled</option>
                </select>
                <select class="filter-select" data-dt-filter="vendor_id" data-dt-table="grnTable">
                    <option value="">All Vendors</option>
                    @foreach($vendors as $id => $name)
                        <option value="{{ $id }}">{{ $name }}</option>
                    @endforeach
                </select>
                @if($warehouses->count())
                <select class="filter-select" data-dt-filter="warehouse_id" data-dt-table="grnTable">
                    <option value="">All Warehouses</option>
                    @foreach($warehouses as $id => $name)
                        <option value="{{ $id }}">{{ $name }}</option>
                    @endforeach
                </select>
                @endif
            </div>
        </div>
        <div class="table-card-body">
            <table class="dt-table dt-search dt-perpage dt-checkbox" 
                   id="grnTable"
                   data-route="{{ route('admin.purchase.grn.data') }}"
                   data-delete-route="{{ route('admin.purchase.grn.bulk-delete') }}">
                <thead>
                    <tr>
                        <th class="dt-sort dt-clickable" data-col="grn_number">GRN Number</th>
                        <th class="dt-sort" data-col="grn_date">Date</th>
                        <th data-col="po_number">PO Number</th>
                        <th data-col="vendor_name">Vendor</th>
                        <th data-col="warehouse_name">Warehouse</th>
                        <th data-col="accepted_qty">Accepted Qty</th>
                        <th data-col="stock_updated" data-render="stock_badge">Stock</th>
                        <th class="dt-sort" data-col="status" data-render="badge">Status</th>
                        <th data-render="actions">Actions</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div id="rejectModal" style="display:none; position:fixed; top:0; left:0; right:0; bottom:0; background:rgba(0,0,0,0.5); z-index:9999; align-items:center; justify-content:center;">
    <div style="background:#fff; padding:20px; border-radius:8px; width:400px; max-width:90%;">
        <h3 style="margin-top:0;">Reject GRN</h3>
        <form id="rejectForm" method="POST">
            @csrf
            <div style="margin-bottom:15px;">
                <label>Reason:</label>
                <textarea name="rejection_reason" required style="width:100%; padding:8px; border:1px solid #ddd; border-radius:4px; min-height:80px;"></textarea>
            </div>
            <div style="text-align:right;">
                <button type="button" onclick="closeRejectModal()" class="btn btn-outline">Cancel</button>
                <button type="submit" class="btn btn-danger">Reject</button>
            </div>
        </form>
    </div>
</div>

@include('components.datatable')

<style>
/* ── Filter styles ── */
.filter-select,
.filter-date {
    padding: 8px 14px;
    border: 1px solid var(--input-border, #d1d5db);
    border-radius: var(--radius-md, 8px);
    font-size: var(--font-sm, 14px);
    background: var(--input-bg, #fff);
    color: var(--input-text, #1f2937);
    cursor: pointer;
    transition: border-color 0.2s;
}
.filter-select { min-width: 150px; }
.filter-date { min-width: 140px; }
.filter-select:focus,
.filter-date:focus {
    outline: none;
    border-color: #5a67d8;
    box-shadow: 0 0 0 3px rgba(90, 103, 216, 0.15);
}
.date-filter-group {
    display: flex;
    align-items: center;
    gap: 6px;
}
.date-filter-label {
    font-size: 13px;
    font-weight: 600;
    color: var(--text-muted, #6b7280);
    white-space: nowrap;
}

/* ── Export button ── */
.grn-export-wrapper { position: relative; display: inline-flex; }
.grn-export-btn {
    display: inline-flex; align-items: center; gap: 8px;
    padding: 10px 20px;
    background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);
    color: #fff; border: none; border-radius: 10px;
    font-size: 14px; font-weight: 600; cursor: pointer;
    white-space: nowrap; line-height: 1;
    box-shadow: 0 2px 8px rgba(22,163,74,0.3);
    transition: all 0.2s;
}
.grn-export-btn:hover {
    background: linear-gradient(135deg, #16a34a 0%, #15803d 100%);
    box-shadow: 0 4px 12px rgba(22,163,74,0.4);
    transform: translateY(-1px);
}
.grn-export-btn:active { transform: translateY(0); }
.grn-export-menu {
    display: none; position: absolute; right: 0; top: calc(100% + 6px);
    background: var(--card-bg, #fff); border: 1px solid var(--card-border, #e5e7eb);
    border-radius: 10px; box-shadow: 0 10px 40px rgba(0,0,0,0.15);
    min-width: 200px; z-index: 1000; padding: 6px 0;
    animation: fadeIn 0.15s ease;
}
@keyframes fadeIn { from { opacity:0; transform:translateY(-4px); } to { opacity:1; transform:translateY(0); } }
.grn-export-menu.show { display: block; }
.grn-export-item {
    display: flex; align-items: center; gap: 12px;
    padding: 11px 16px; font-size: 14px; font-weight: 500;
    color: var(--text-primary, #1f2937);
    cursor: pointer; border: none; background: none; width: 100%; text-align: left;
    transition: background 0.15s;
}
.grn-export-item:hover { background: var(--hover-bg, #f0fdf4); }
.grn-export-item .ei {
    width: 28px; height: 28px; display: inline-flex; align-items: center;
    justify-content: center; border-radius: 6px; font-size: 14px; flex-shrink: 0;
}
.grn-export-item .ei.csv  { background: #dbeafe; }
.grn-export-item .ei.xlsx { background: #d1fae5; }
.grn-export-item .ei.pdf  { background: #fee2e2; }
</style>

<script>
window.dtRenders = window.dtRenders || {};
window.dtRenders['stock_badge'] = function(value, row) {
    if (value === true || value === 'Updated' || value === 1 || value === '1') {
        return '<span class="dt-badge dt-badge-success">Updated</span>';
    }
    return '<span class="dt-badge dt-badge-warning">Pending</span>';
};

function quickApprove(url) {
    if (confirm('Approve this GRN and update stock?')) {
        var form = document.createElement('form');
        form.method = 'POST'; form.action = url; form.innerHTML = '@csrf';
        document.body.appendChild(form); form.submit();
    }
}
function showRejectModal(url) {
    document.getElementById('rejectForm').action = url;
    document.getElementById('rejectModal').style.display = 'flex';
}
function closeRejectModal() { document.getElementById('rejectModal').style.display = 'none'; }

// ═══════════════════════════════════════════
// Date Filter — bind to datatable instance
// ═══════════════════════════════════════════
document.addEventListener('DOMContentLoaded', function() {
    // Wait for datatable to initialize
    setTimeout(function() {
        var dt = window.dtInstance && window.dtInstance['grnTable'];
        if (!dt) return;

        var fromInput = document.getElementById('grnFilterFromDate');
        var toInput   = document.getElementById('grnFilterToDate');

        fromInput.addEventListener('change', function() {
            dt.setFilter('from_date', this.value);
        });

        toInput.addEventListener('change', function() {
            dt.setFilter('to_date', this.value);
        });
    }, 1000);
});

// ═══════════════════════════════════════════
// Direct Export (current month, no modal)
// ═══════════════════════════════════════════
function doExport(format) {
    var menu = document.querySelector('.grn-export-menu');
    if (menu) menu.classList.remove('show');

    var now = new Date();
    var from = now.getFullYear() + '-' + String(now.getMonth()+1).padStart(2,'0') + '-01';
    var lastDay = new Date(now.getFullYear(), now.getMonth()+1, 0).getDate();
    var to = now.getFullYear() + '-' + String(now.getMonth()+1).padStart(2,'0') + '-' + String(lastDay).padStart(2,'0');

    // Use date filter values if set
    var fromInput = document.getElementById('grnFilterFromDate');
    var toInput   = document.getElementById('grnFilterToDate');
    if (fromInput && fromInput.value) from = fromInput.value;
    if (toInput && toInput.value) to = toInput.value;

    var url = '{{ route("admin.purchase.grn.export-gstr2") }}' +
        '?format=' + format + '&from_date=' + from + '&to_date=' + to;

    var iframe = document.getElementById('downloadFrame');
    if (!iframe) {
        iframe = document.createElement('iframe');
        iframe.id = 'downloadFrame';
        iframe.style.display = 'none';
        document.body.appendChild(iframe);
    }
    iframe.src = url;
}

// ═══════════════════════════════════════════
// Export Dropdown
// ═══════════════════════════════════════════
function toggleGrnExport(e) {
    e.stopPropagation();
    var menu = document.querySelector('.grn-export-menu');
    if (menu) menu.classList.toggle('show');
}
document.addEventListener('click', function(e) {
    var w = document.querySelector('.grn-export-wrapper');
    if (w && !w.contains(e.target)) {
        var m = document.querySelector('.grn-export-menu');
        if (m) m.classList.remove('show');
    }
});

// ═══════════════════════════════════════════
// Inject Export button into toolbar
// ═══════════════════════════════════════════
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(function() {
        var table = document.getElementById('grnTable');
        if (!table) return;
        var tableBody = table.closest('.table-card-body');
        if (!tableBody) return;

        var toolbar = tableBody.querySelector('.dt-toolbar, .dt-controls, .dt-top');
        if (!toolbar) {
            var allDivs = tableBody.querySelectorAll('div');
            for (var i = 0; i < allDivs.length; i++) {
                if (allDivs[i].querySelector('input, select') && allDivs[i].offsetHeight < 80) {
                    toolbar = allDivs[i]; break;
                }
            }
        }
        if (!toolbar) toolbar = tableBody;

        var wrapper = document.createElement('div');
        wrapper.className = 'grn-export-wrapper';
        wrapper.innerHTML =
            '<button type="button" class="grn-export-btn" onclick="toggleGrnExport(event)">' +
                '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round">' +
                    '<path d="M21 15v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4"/>' +
                    '<polyline points="7 10 12 15 17 10"/>' +
                    '<line x1="12" y1="15" x2="12" y2="3"/>' +
                '</svg>' +
                'Export <span style="font-size:10px; margin-left:2px;">▼</span>' +
            '</button>' +
            '<div class="grn-export-menu">' +
                '<button type="button" class="grn-export-item" onclick="doExport(\'csv\')">' +
                    '<span class="ei csv">📋</span> CSV' +
                '</button>' +
                '<button type="button" class="grn-export-item" onclick="doExport(\'xlsx\')">' +
                    '<span class="ei xlsx">📊</span> Excel (GSTR2)' +
                '</button>' +
                '<button type="button" class="grn-export-item" onclick="doExport(\'pdf\')">' +
                    '<span class="ei pdf">📕</span> PDF' +
                '</button>' +
            '</div>';

        wrapper.style.cssText = 'margin-left:auto;';
        toolbar.style.display = 'flex';
        toolbar.style.alignItems = 'center';
        toolbar.style.flexWrap = 'wrap';
        toolbar.style.gap = '10px';
        toolbar.appendChild(wrapper);
    }, 800);

    var originalRender = window.dtRenderActions;
    if (originalRender) {
        window.dtRenderActions = function(row) {
            var html = '';
            if (row._approve_url) html += '<button onclick="quickApprove(\'' + row._approve_url + '\')" class="btn btn-success btn-sm" title="Approve">✅</button> ';
            if (row._reject_url) html += '<button onclick="showRejectModal(\'' + row._reject_url + '\')" class="btn btn-danger btn-sm" title="Reject">❌</button> ';
            if (row._bill_url) html += '<a href="' + row._bill_url + '" class="btn btn-info btn-sm" title="Create Bill">📄 Bill</a> ';
            return html + originalRender(row);
        };
    }
});
</script>