<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>GRN - {{ $grn->grn_number }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: DejaVu Sans, sans-serif; font-size: 10px; line-height: 1.4; color: #333; }
        .container { padding: 20px; }
        .header { display: table; width: 100%; margin-bottom: 20px; border-bottom: 2px solid #059669; padding-bottom: 15px; }
        .header-left { display: table-cell; width: 60%; vertical-align: top; }
        .header-right { display: table-cell; width: 40%; vertical-align: top; text-align: right; }
        .company-name { font-size: 18px; font-weight: bold; color: #065f46; margin-bottom: 5px; }
        .company-details { font-size: 9px; color: #666; line-height: 1.5; }
        .doc-title { font-size: 22px; font-weight: bold; color: #065f46; margin-bottom: 8px; }
        .doc-number { font-size: 12px; color: #666; }
        .info-section { display: table; width: 100%; margin-bottom: 15px; }
        .info-box { display: table-cell; width: 50%; vertical-align: top; padding: 10px; background: #f8fafc; border: 1px solid #e2e8f0; }
        .info-box:first-child { border-right: none; }
        .info-title { font-size: 10px; font-weight: bold; color: #065f46; margin-bottom: 8px; text-transform: uppercase; border-bottom: 1px solid #cbd5e1; padding-bottom: 4px; }
        .info-row { margin-bottom: 3px; }
        .info-label { color: #666; display: inline-block; width: 90px; }
        .info-value { font-weight: 500; }
        table.items { width: 100%; border-collapse: collapse; margin-bottom: 15px; }
        table.items th { background: #065f46; color: white; padding: 8px 5px; font-size: 9px; text-align: left; font-weight: 600; }
        table.items th.right { text-align: right; }
        table.items th.center { text-align: center; }
        table.items td { padding: 8px 5px; border-bottom: 1px solid #e2e8f0; font-size: 9px; vertical-align: top; }
        table.items td.right { text-align: right; }
        table.items td.center { text-align: center; }
        table.items tr:nth-child(even) { background: #f8fafc; }
        .summary-section { display: table; width: 100%; margin-top: 15px; }
        .notes-box { display: table-cell; width: 55%; vertical-align: top; padding-right: 20px; }
        .totals-box { display: table-cell; width: 45%; vertical-align: top; }
        .notes-title { font-weight: bold; color: #065f46; margin-bottom: 5px; font-size: 10px; }
        .notes-content { font-size: 8px; color: #666; line-height: 1.5; }
        table.totals { width: 100%; border-collapse: collapse; }
        table.totals td { padding: 6px 10px; font-size: 10px; }
        table.totals td:first-child { text-align: left; color: #666; }
        table.totals td:last-child { text-align: right; font-weight: 500; }
        table.totals tr.grand { background: #065f46; color: white; }
        table.totals tr.grand td { font-size: 12px; font-weight: bold; padding: 10px; }
        .signature-section { margin-top: 40px; display: table; width: 100%; }
        .signature-box { display: table-cell; width: 33%; text-align: center; }
        .signature-line { border-top: 1px solid #333; width: 130px; margin: 30px auto 5px; }
        .signature-text { font-size: 9px; color: #666; }
        .footer { margin-top: 30px; text-align: center; font-size: 8px; color: #999; border-top: 1px solid #e2e8f0; padding-top: 10px; }
        .status-badge { display: inline-block; padding: 3px 10px; border-radius: 12px; font-size: 9px; font-weight: bold; }
        .status-DRAFT { background: #fef3c7; color: #92400e; }
        .status-INSPECTING { background: #dbeafe; color: #1e40af; }
        .status-APPROVED { background: #d1fae5; color: #065f46; }
        .status-REJECTED { background: #fee2e2; color: #991b1b; }
        .qty-accepted { color: #059669; font-weight: 600; }
        .qty-rejected { color: #dc2626; font-weight: 600; }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <div class="header-left">
            <div class="company-name">{{ $company['name'] ?? config('app.name') }}</div>
            <div class="company-details">
                @if(!empty($company['address'])){{ $company['address'] }}<br>@endif
                @if(!empty($company['city']) || !empty($company['state'])){{ $company['city'] }}{{ !empty($company['city']) && !empty($company['state']) ? ', ' : '' }}{{ $company['state'] }} {{ $company['zip'] ?? '' }}<br>@endif
                @if(!empty($company['phone']))Phone: {{ $company['phone'] }}<br>@endif
                @if(!empty($company['email']))Email: {{ $company['email'] }}<br>@endif
                @if(!empty($company['gst']))GSTIN: {{ $company['gst'] }}@endif
            </div>
        </div>
        <div class="header-right">
            <div class="doc-title">GOODS RECEIPT NOTE</div>
            <div class="doc-number">
                <strong>{{ $grn->grn_number }}</strong><br>
                Date: {{ $grn->grn_date->format('d M Y') }}<br>
                <span class="status-badge status-{{ $grn->status }}">{{ $grn->status }}</span>
            </div>
        </div>
    </div>

    <div class="info-section">
        <div class="info-box">
            <div class="info-title">Vendor Details</div>
            <div style="font-weight: bold; margin-bottom: 5px;">{{ $grn->vendor->name ?? '-' }}</div>
            @if($grn->vendor)
                @if($grn->vendor->vendor_code)<div>Code: {{ $grn->vendor->vendor_code }}</div>@endif
                @if($grn->vendor->address)<div>{{ $grn->vendor->address }}</div>@endif
                @if($grn->vendor->city || $grn->vendor->state)<div>{{ $grn->vendor->city }}{{ $grn->vendor->city && $grn->vendor->state ? ', ' : '' }}{{ $grn->vendor->state }} {{ $grn->vendor->pincode }}</div>@endif
                @if($grn->vendor->phone)<div>Phone: {{ $grn->vendor->phone }}</div>@endif
                @if($grn->vendor->gst_number)<div>GSTIN: {{ $grn->vendor->gst_number }}</div>@endif
            @endif
        </div>
        <div class="info-box">
            <div class="info-title">Receipt Details</div>
            @if($grn->purchaseOrder)
            <div class="info-row"><span class="info-label">Purchase Order:</span> <span class="info-value">{{ $grn->purchaseOrder->po_number }}</span></div>
            @endif
            <div class="info-row"><span class="info-label">Warehouse:</span> <span class="info-value">{{ $grn->warehouse->name ?? '-' }}</span></div>
            @if($grn->rack)<div class="info-row"><span class="info-label">Rack:</span> <span class="info-value">{{ $grn->rack->name ?? $grn->rack->code }}</span></div>@endif
            @if($grn->invoice_number)<div class="info-row"><span class="info-label">Invoice No:</span> <span class="info-value">{{ $grn->invoice_number }}</span></div>@endif
            @if($grn->invoice_date)<div class="info-row"><span class="info-label">Invoice Date:</span> <span class="info-value">{{ $grn->invoice_date->format('d M Y') }}</span></div>@endif
            @if($grn->lr_number)<div class="info-row"><span class="info-label">LR/Docket No:</span> <span class="info-value">{{ $grn->lr_number }}</span></div>@endif
            @if($grn->vehicle_number)<div class="info-row"><span class="info-label">Vehicle No:</span> <span class="info-value">{{ $grn->vehicle_number }}</span></div>@endif
            <div class="info-row"><span class="info-label">Received By:</span> <span class="info-value">{{ $grn->receiver->name ?? '-' }}</span></div>
        </div>
    </div>

    <table class="items">
        <thead>
            <tr>
                <th style="width:25px">#</th>
                <th>Product</th>
                <th style="width:35px">Unit</th>
                <th style="width:50px" class="right">Ordered</th>
                <th style="width:50px" class="right">Received</th>
                <th style="width:55px" class="right">Accepted</th>
                <th style="width:55px" class="right">Rejected</th>
                <th style="width:60px" class="right">Rate</th>
                <th style="width:50px">Tax</th>
                <th style="width:75px" class="right">Amount</th>
                <th style="width:55px">Lot/Batch</th>
            </tr>
        </thead>
        <tbody>
            @php $totalValue = 0; $totalTax = 0; @endphp
            @foreach($grn->items as $i => $item)
            @php
                $lineTotal = $item->accepted_qty * $item->rate;
                $taxRate = ($item->tax_1_rate ?? 0) + ($item->tax_2_rate ?? 0);
                $taxableAmt = $taxRate > 0 ? ($lineTotal / (1 + $taxRate / 100)) : $lineTotal;
                $taxAmt = $lineTotal - $taxableAmt;
                $totalValue += $lineTotal;
                $totalTax += $taxAmt;
            @endphp
            <tr>
                <td>{{ $i + 1 }}</td>
                <td>
                    <strong>{{ $item->product->name ?? 'N/A' }}</strong>
                    @if($item->variation)<br><span style="color:#8b5cf6;font-size:8px">{{ $item->variation->variation_name ?: $item->variation->sku }}</span>@endif
                    @if($item->product && $item->product->sku)<br><span style="color:#666;font-size:8px">SKU: {{ $item->product->sku }}</span>@endif
                    @if($item->product && $item->product->hsn_code)<br><span style="color:#666;font-size:8px">HSN: {{ $item->product->hsn_code }}</span>@endif
                </td>
                <td>{{ $item->unit->short_name ?? '-' }}</td>
                <td class="right">{{ number_format($item->ordered_qty, 2) }}</td>
                <td class="right">{{ number_format($item->received_qty, 2) }}</td>
                <td class="right qty-accepted">{{ number_format($item->accepted_qty, 2) }}</td>
                <td class="right qty-rejected">{{ $item->rejected_qty > 0 ? number_format($item->rejected_qty, 2) : '-' }}</td>
                <td class="right">&#x20B9;{{ number_format($item->rate, 2) }}</td>
                <td>
                    @if($item->tax_1_name){{ $item->tax_1_name }} ({{ $item->tax_1_rate }}%)@elseif($taxRate > 0)GST {{ $taxRate }}%@else - @endif
                </td>
                <td class="right"><strong>&#x20B9;{{ number_format($lineTotal, 2) }}</strong></td>
                <td style="font-size:8px;">
                    @if($item->lot_no)L: {{ $item->lot_no }}<br>@endif
                    @if($item->batch_no)B: {{ $item->batch_no }}<br>@endif
                    @if($item->expiry_date)Exp: {{ $item->expiry_date->format('d/m/Y') }}@endif
                    @if(!$item->lot_no && !$item->batch_no) - @endif
                </td>
            </tr>
            @if($item->rejection_reason)
            <tr>
                <td></td>
                <td colspan="10" style="color:#dc2626;font-size:8px;padding-top:0;">Rejection: {{ $item->rejection_reason }}</td>
            </tr>
            @endif
            @endforeach
        </tbody>
    </table>

    <div class="summary-section">
        <div class="notes-box">
            @if($grn->notes)
            <div class="notes-title">Notes</div>
            <div class="notes-content">{!! nl2br(e($grn->notes)) !!}</div>
            @endif
            
            <div style="margin-top:10px;">
                <div class="notes-title">Quantity Summary</div>
                <div class="notes-content" style="font-size:9px;">
                    Total Received: <strong>{{ number_format($grn->total_qty, 3) }}</strong> |
                    Accepted: <strong style="color:#059669;">{{ number_format($grn->accepted_qty, 3) }}</strong> |
                    Rejected: <strong style="color:#dc2626;">{{ number_format($grn->rejected_qty, 3) }}</strong>
                </div>
            </div>
        </div>
        <div class="totals-box">
            <table class="totals">
                <tr><td>Taxable Amount</td><td>&#x20B9;{{ number_format($totalValue - $totalTax, 2) }}</td></tr>
                <tr><td>Tax Amount</td><td>&#x20B9;{{ number_format($totalTax, 2) }}</td></tr>
                <tr class="grand"><td>Total Value</td><td>&#x20B9;{{ number_format($totalValue, 2) }}</td></tr>
            </table>
        </div>
    </div>

    @if($settings['show_signature'] ?? true)
    <div class="signature-section">
        <div class="signature-box">
            <div class="signature-line"></div>
            <div class="signature-text">Received By</div>
        </div>
        <div class="signature-box">
            <div class="signature-line"></div>
            <div class="signature-text">Inspected By</div>
        </div>
        <div class="signature-box">
            <div class="signature-line"></div>
            <div class="signature-text">{{ $settings['signature_text'] ?? 'Authorized Signatory' }}</div>
        </div>
    </div>
    @endif

    @if(!empty($settings['footer_text']))
    <div class="footer">{!! $settings['footer_text'] !!}</div>
    @endif
</div>
</body>
</html>
