@include('purchase::partials.styles')


<div style="padding: 20px;">
    <div class="page-header">
        <h1>Purchase Requests</h1>
        <a href="{{ route('admin.purchase.requests.create') }}" class="btn-add">+ New Request</a>
    </div>

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon total">📋</div>
            <div><div class="stat-value">{{ $stats['total'] }}</div><div class="stat-label">Total</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon draft">📝</div>
            <div><div class="stat-value">{{ $stats['draft'] }}</div><div class="stat-label">Draft</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon pending">⏳</div>
            <div><div class="stat-value">{{ $stats['pending'] }}</div><div class="stat-label">Pending</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon approved">✅</div>
            <div><div class="stat-value">{{ $stats['approved'] }}</div><div class="stat-label">Approved</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon rejected">❌</div>
            <div><div class="stat-value">{{ $stats['rejected'] }}</div><div class="stat-label">Rejected</div></div>
        </div>
    </div>

    <div class="table-card">
        <div class="table-card-header">
            <div class="table-card-title">Purchase Request List</div>
        </div>
        <div class="table-card-body">
            <table class="dt-table dt-search dt-export dt-perpage dt-checkbox" 
                   data-route="{{ route('admin.purchase.requests.data') }}"
                   data-delete-route="{{ route('admin.purchase.requests.bulk-delete') }}">
                <thead>
                    <tr>
                        <th class="dt-sort dt-clickable" data-col="pr_number">PR Number</th>
                        <th class="dt-sort" data-col="pr_date">Date</th>
                        <th data-col="department">Department</th>
                        <th data-col="items_count">Items</th>
                        <th class="dt-sort" data-col="priority" data-render="badge">Priority</th>
                        <th data-col="requester_name">Requested By</th>
                        <th class="dt-sort" data-col="status" data-render="badge">Status</th>
                        <th data-render="actions">Actions</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

@include('components.datatable')

<!-- Reject Modal -->
<div id="rejectModal" style="display:none; position:fixed; top:0; left:0; right:0; bottom:0; background:rgba(0,0,0,0.5); z-index:9999; align-items:center; justify-content:center;">
    <div style="background:#fff; padding:20px; border-radius:8px; width:400px; max-width:90%;">
        <h3 style="margin-top:0;">Reject Purchase Request</h3>
        <form id="rejectForm" method="POST">
            @csrf
            <div style="margin-bottom:15px;">
                <label>Reason:</label>
                <textarea name="rejection_reason" required style="width:100%; padding:8px; border:1px solid #ddd; border-radius:4px; min-height:80px;"></textarea>
            </div>
            <div style="text-align:right;">
                <button type="button" onclick="closeRejectModal()" class="btn btn-outline">Cancel</button>
                <button type="submit" class="btn btn-danger">Reject</button>
            </div>
        </form>
    </div>
</div>

<script>
function quickApprove(url) {
    if (confirm('Approve this Purchase Request?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = url;
        form.innerHTML = '@csrf';
        document.body.appendChild(form);
        form.submit();
    }
}

function showRejectModal(url) {
    document.getElementById('rejectForm').action = url;
    document.getElementById('rejectModal').style.display = 'flex';
}

function closeRejectModal() {
    document.getElementById('rejectModal').style.display = 'none';
}

// Add quick action buttons
document.addEventListener('DOMContentLoaded', function() {
    const originalRender = window.dtRenderActions;
    if (originalRender) {
        window.dtRenderActions = function(row) {
            let html = '';
            if (row._approve_url) {
                html += `<button onclick="quickApprove('${row._approve_url}')" class="btn btn-success btn-sm" title="Approve">✅</button> `;
            }
            if (row._reject_url) {
                html += `<button onclick="showRejectModal('${row._reject_url}')" class="btn btn-danger btn-sm" title="Reject">❌</button> `;
            }
            if (row._convert_url) {
                html += `<a href="${row._convert_url}" class="btn btn-primary btn-sm" title="Create PO">🛒 PO</a> `;
            }
            return html + originalRender(row);
        };
    }
});
</script>
