@include('purchase::partials.styles')


<div class="page-header">
    <h1>Edit Vendor: {{ $vendor->name }}</h1>
    <a href="{{ route('admin.purchase.vendors.index') }}" class="btn btn-outline">
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="19" y1="12" x2="5" y2="12"/><polyline points="12 19 5 12 12 5"/></svg>
        Back
    </a>
</div>

@if($errors->any())
<div class="alert alert-danger">
    <ul>@foreach($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
</div>
@endif

<form action="{{ route('admin.purchase.vendors.update', $vendor->id) }}" method="POST" id="vendorForm">
    @csrf
    @method('PUT')

    <div class="card">
        <div class="card-header"><h5>Basic Information</h5></div>
        <div class="card-body">
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Vendor Code</label>
                    <input type="text" class="form-control" value="{{ $vendor->vendor_code }}" readonly>
                </div>
                <div class="form-group col-2">
                    <label class="form-label">Vendor Name <span class="required">*</span></label>
                    <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $vendor->name) }}" required minlength="2" maxlength="191">
                    <div class="invalid-feedback">Vendor name is required (2-191 characters)</div>
                </div>
                <div class="form-group">
                    <label class="form-label">Display Name</label>
                    <input type="text" name="display_name" class="form-control" value="{{ old('display_name', $vendor->display_name) }}" maxlength="191">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Contact Person</label>
                    <input type="text" name="contact_person" class="form-control" value="{{ old('contact_person', $vendor->contact_person) }}" maxlength="191">
                </div>
                <div class="form-group">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control" value="{{ old('email', $vendor->email) }}" maxlength="191">
                    <div class="invalid-feedback">Please enter a valid email address</div>
                </div>
                <div class="form-group">
                    <label class="form-label">Phone</label>
                    <input type="tel" name="phone" class="form-control" value="{{ old('phone', $vendor->phone) }}" maxlength="20">
                </div>
                <div class="form-group">
                    <label class="form-label">Mobile</label>
                    <input type="tel" name="mobile" class="form-control" value="{{ old('mobile', $vendor->mobile) }}" maxlength="20">
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header"><h5>Tax Information</h5></div>
        <div class="card-body">
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">GST Type <span class="required">*</span></label>
                    <select name="gst_type" id="gstType" class="form-control" required onchange="toggleGstFields()">
                        <option value="REGISTERED" {{ old('gst_type', $vendor->gst_type) == 'REGISTERED' ? 'selected' : '' }}>Registered</option>
                        <option value="UNREGISTERED" {{ old('gst_type', $vendor->gst_type) == 'UNREGISTERED' ? 'selected' : '' }}>Unregistered</option>
                        <option value="COMPOSITION" {{ old('gst_type', $vendor->gst_type) == 'COMPOSITION' ? 'selected' : '' }}>Composition</option>
                        <option value="SEZ" {{ old('gst_type', $vendor->gst_type) == 'SEZ' ? 'selected' : '' }}>SEZ</option>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">GST Number <span class="required gst-required">*</span></label>
                    <input type="text" name="gst_number" id="gstNumber" class="form-control" value="{{ old('gst_number', $vendor->gst_number) }}" maxlength="15" placeholder="22AAAAA0000A1Z5" style="text-transform: uppercase;">
                    <div class="invalid-feedback">Enter valid 15-character GST number</div>
                </div>
                <div class="form-group">
                    <label class="form-label">PAN Number</label>
                    <input type="text" name="pan_number" id="panNumber" class="form-control" value="{{ old('pan_number', $vendor->pan_number) }}" maxlength="10" placeholder="AAAAA0000A" style="text-transform: uppercase;">
                    <div class="invalid-feedback">Enter valid 10-character PAN number</div>
                </div>
                <div class="form-group">
                    <label class="form-label">Status <span class="required">*</span></label>
                    <select name="status" class="form-control" required>
                        <option value="ACTIVE" {{ old('status', $vendor->status) == 'ACTIVE' ? 'selected' : '' }}>Active</option>
                        <option value="INACTIVE" {{ old('status', $vendor->status) == 'INACTIVE' ? 'selected' : '' }}>Inactive</option>
                        <option value="BLOCKED" {{ old('status', $vendor->status) == 'BLOCKED' ? 'selected' : '' }}>Blocked</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header"><h5>Billing Address</h5></div>
        <div class="card-body">
            <div class="form-row">
                <div class="form-group col-full">
                    <label class="form-label">Address</label>
                    <textarea name="billing_address" class="form-control" rows="2" maxlength="500">{{ old('billing_address', $vendor->billing_address) }}</textarea>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">City</label>
                    <input type="text" name="billing_city" class="form-control" value="{{ old('billing_city', $vendor->billing_city) }}" maxlength="100">
                </div>
                <div class="form-group">
                    <label class="form-label">State</label>
                    <input type="text" name="billing_state" class="form-control" value="{{ old('billing_state', $vendor->billing_state) }}" maxlength="100">
                </div>
                <div class="form-group">
                    <label class="form-label">Pincode</label>
                    <input type="text" name="billing_pincode" class="form-control" value="{{ old('billing_pincode', $vendor->billing_pincode) }}" maxlength="10">
                </div>
                <div class="form-group">
                    <label class="form-label">Country</label>
                    <input type="text" name="billing_country" class="form-control" value="{{ old('billing_country', $vendor->billing_country ?? 'India') }}" maxlength="100">
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header"><h5>Financial Settings</h5></div>
        <div class="card-body">
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Payment Terms</label>
                    <select name="payment_terms" class="form-control">
                        <option value="Immediate" {{ old('payment_terms', $vendor->payment_terms) == 'Immediate' ? 'selected' : '' }}>Immediate</option>
                        <option value="Net 15" {{ old('payment_terms', $vendor->payment_terms) == 'Net 15' ? 'selected' : '' }}>Net 15</option>
                        <option value="Net 30" {{ old('payment_terms', $vendor->payment_terms) == 'Net 30' ? 'selected' : '' }}>Net 30</option>
                        <option value="Net 45" {{ old('payment_terms', $vendor->payment_terms) == 'Net 45' ? 'selected' : '' }}>Net 45</option>
                        <option value="Net 60" {{ old('payment_terms', $vendor->payment_terms) == 'Net 60' ? 'selected' : '' }}>Net 60</option>
                        <option value="Net 90" {{ old('payment_terms', $vendor->payment_terms) == 'Net 90' ? 'selected' : '' }}>Net 90</option>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">Credit Days</label>
                    <input type="number" name="credit_days" class="form-control" value="{{ old('credit_days', $vendor->credit_days) }}" min="0" max="365">
                </div>
                <div class="form-group">
                    <label class="form-label">Credit Limit (₹)</label>
                    <input type="number" name="credit_limit" class="form-control" value="{{ old('credit_limit', $vendor->credit_limit) }}" step="0.01" min="0">
                </div>
                <div class="form-group">
                    <label class="form-label">Current Balance (₹)</label>
                    <input type="text" class="form-control" value="{{ number_format($vendor->current_balance ?? 0, 2) }}" readonly>
                </div>
            </div>
        </div>
    </div>

    <!-- Bank Details -->
    <div class="card">
        <div class="card-header"><h5>🏦 Bank Details</h5></div>
        <div class="card-body">
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Account Holder Name</label>
                    <input type="text" name="bank_account_holder" class="form-control" value="{{ old('bank_account_holder', $bankDetail->account_holder_name ?? '') }}" placeholder="Account holder name">
                </div>
                <div class="form-group">
                    <label class="form-label">Bank Name</label>
                    <input type="text" name="bank_name" class="form-control" value="{{ old('bank_name', $bankDetail->bank_name ?? '') }}" placeholder="e.g., State Bank of India">
                </div>
                <div class="form-group">
                    <label class="form-label">Account Number</label>
                    <input type="text" name="bank_account_number" class="form-control" value="{{ old('bank_account_number', $bankDetail->account_number ?? '') }}" placeholder="Account number">
                </div>
                <div class="form-group">
                    <label class="form-label">Account Type</label>
                    <select name="bank_account_type" class="form-control">
                        <option value="CURRENT" {{ old('bank_account_type', $bankDetail->account_type ?? 'CURRENT') == 'CURRENT' ? 'selected' : '' }}>Current</option>
                        <option value="SAVINGS" {{ old('bank_account_type', $bankDetail->account_type ?? '') == 'SAVINGS' ? 'selected' : '' }}>Savings</option>
                        <option value="OTHER" {{ old('bank_account_type', $bankDetail->account_type ?? '') == 'OTHER' ? 'selected' : '' }}>Other</option>
                    </select>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">IFSC Code</label>
                    <input type="text" name="bank_ifsc" class="form-control" value="{{ old('bank_ifsc', $bankDetail->ifsc_code ?? '') }}" placeholder="e.g., SBIN0001234" style="text-transform: uppercase;">
                </div>
                <div class="form-group">
                    <label class="form-label">Branch Name</label>
                    <input type="text" name="bank_branch" class="form-control" value="{{ old('bank_branch', $bankDetail->branch_name ?? '') }}" placeholder="Branch name">
                </div>
                <div class="form-group col-2">
                    <label class="form-label">UPI ID</label>
                    <input type="text" name="bank_upi_id" class="form-control" value="{{ old('bank_upi_id', $bankDetail->upi_id ?? '') }}" placeholder="e.g., vendor@upi">
                </div>
            </div>
        </div>
    </div>

    <!-- ========== VENDOR ITEMS SECTION ========== -->
    <div class="card">
        <div class="card-header" style="display:flex;justify-content:space-between;align-items:center;">
            <h5>📦 Vendor Items <span style="font-size:12px;color:var(--text-secondary);font-weight:400;margin-left:8px;">({{ $vendorItems->count() }} items)</span></h5>
            <button type="button" class="btn btn-primary" id="addVendorItemBtn" style="padding: 6px 16px; font-size: 13px;">
                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="12" y1="5" x2="12" y2="19"/><line x1="5" y1="12" x2="19" y2="12"/></svg>
                Add Item
            </button>
        </div>
        <div class="card-body" style="padding: 0;">
            <div id="vendorItemsEmpty" style="text-align:center;padding:40px 20px;color:var(--text-secondary);{{ $vendorItems->count() > 0 ? 'display:none;' : '' }}">
                <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" style="opacity:0.4;margin-bottom:12px;">
                    <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/>
                </svg>
                <p style="margin:0;">No items added yet. Click <strong>"Add Item"</strong> to add products this vendor supplies.</p>
            </div>
            <div style="overflow-x: auto;">
                <table class="items-table" id="vendorItemsTable" style="{{ $vendorItems->count() > 0 ? '' : 'display:none;' }}width:100%;border-collapse:collapse;">
                    <thead>
                        <tr style="background:var(--bg-secondary);border-bottom:2px solid var(--border);">
                            <th style="padding:10px 12px;text-align:left;min-width:250px;font-size:12px;font-weight:600;text-transform:uppercase;color:var(--text-secondary);">Product</th>
                            <th style="padding:10px 12px;text-align:left;min-width:100px;font-size:12px;font-weight:600;text-transform:uppercase;color:var(--text-secondary);">Vendor SKU</th>
                            <th style="padding:10px 12px;text-align:left;min-width:100px;font-size:12px;font-weight:600;text-transform:uppercase;color:var(--text-secondary);">Unit</th>
                            <th style="padding:10px 12px;text-align:right;min-width:120px;font-size:12px;font-weight:600;text-transform:uppercase;color:var(--text-secondary);">Purchase Price</th>
                            <th style="padding:10px 12px;text-align:right;min-width:80px;font-size:12px;font-weight:600;text-transform:uppercase;color:var(--text-secondary);">MOQ</th>
                            <th style="padding:10px 12px;text-align:right;min-width:80px;font-size:12px;font-weight:600;text-transform:uppercase;color:var(--text-secondary);">Lead Days</th>
                            <th style="padding:10px 12px;text-align:center;min-width:70px;font-size:12px;font-weight:600;text-transform:uppercase;color:var(--text-secondary);">Preferred</th>
                            <th style="padding:10px 12px;text-align:center;min-width:60px;font-size:12px;font-weight:600;text-transform:uppercase;color:var(--text-secondary);">Action</th>
                        </tr>
                    </thead>
                    <tbody id="vendorItemsBody">
                        {{-- Render existing vendor items --}}
                        @foreach($vendorItems as $idx => $item)
                        <tr style="border-bottom:1px solid var(--border);">
                            <td style="padding:10px 12px;">
                                <div style="font-weight:500;font-size:13px;">
                                    {{ $item->product->name ?? 'Unknown' }}
                                    @if($item->variation)
                                        <span style="background:#8b5cf6;color:#fff;padding:1px 6px;border-radius:4px;font-size:11px;margin-left:4px;">{{ $item->variation->variation_name ?? $item->variation->sku }}</span>
                                    @endif
                                </div>
                                <div style="font-size:11px;color:var(--text-secondary);margin-top:2px;">SKU: {{ $item->product->sku ?? '-' }}</div>
                                <input type="hidden" name="vendor_items[{{ $idx }}][id]" value="{{ $item->id }}">
                                <input type="hidden" name="vendor_items[{{ $idx }}][product_id]" value="{{ $item->product_id }}">
                                <input type="hidden" name="vendor_items[{{ $idx }}][variation_id]" value="{{ $item->variation_id }}">
                            </td>
                            <td style="padding:10px 12px;">
                                <input type="text" name="vendor_items[{{ $idx }}][vendor_sku]" class="form-control" value="{{ $item->vendor_sku }}" placeholder="Vendor SKU" style="min-width:90px;">
                            </td>
                            <td style="padding:10px 12px;">
                                <span style="font-size:13px;">{{ $item->unit->short_name ?? $item->unit->name ?? ($item->product && $item->product->unit ? ($item->product->unit->short_name ?? $item->product->unit->name) : '-') }}</span>
                                <input type="hidden" name="vendor_items[{{ $idx }}][unit_id]" value="{{ $item->unit_id ?? ($item->product ? $item->product->unit_id : '') }}">
                            </td>
                            <td style="padding:10px 12px;">
                                <input type="number" name="vendor_items[{{ $idx }}][purchase_price]" class="form-control" value="{{ $item->purchase_price }}" step="0.01" min="0" style="text-align:right;min-width:100px;">
                            </td>
                            <td style="padding:10px 12px;">
                                <input type="number" name="vendor_items[{{ $idx }}][moq]" class="form-control" value="{{ $item->moq }}" step="0.001" min="0" style="text-align:right;min-width:70px;">
                            </td>
                            <td style="padding:10px 12px;">
                                <input type="number" name="vendor_items[{{ $idx }}][lead_days]" class="form-control" value="{{ $item->lead_days }}" min="0" style="text-align:right;min-width:70px;">
                            </td>
                            <td style="padding:10px 12px;text-align:center;">
                                <input type="checkbox" name="vendor_items[{{ $idx }}][is_preferred]" value="1" {{ $item->is_preferred ? 'checked' : '' }} style="width:18px;height:18px;cursor:pointer;">
                            </td>
                            <td style="padding:10px 12px;text-align:center;">
                                <button type="button" onclick="removeVendorItem(this)" style="background:none;border:none;color:var(--danger, #ef4444);cursor:pointer;padding:4px;" title="Remove">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="3 6 5 6 21 6"/><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/></svg>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="form-actions">
        <div class="form-actions-left">
            <button type="button" class="btn btn-danger" onclick="if(confirm('Are you sure you want to delete this vendor?')) document.getElementById('deleteForm').submit();">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="3 6 5 6 21 6"/><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/></svg>
                Delete
            </button>
        </div>
        <div class="form-actions-right">
            <a href="{{ route('admin.purchase.vendors.show', $vendor->id) }}" class="btn btn-outline">Cancel</a>
            <button type="submit" class="btn btn-primary">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/></svg>
                Update Vendor
            </button>
        </div>
    </div>
</form>

<form id="deleteForm" action="{{ route('admin.purchase.vendors.destroy', $vendor->id) }}" method="POST" style="display:none;">
    @csrf
    @method('DELETE')
</form>

<!-- Product Search Modal -->
<div id="productSearchModal" style="display:none;position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);z-index:9999;justify-content:center;align-items:flex-start;padding-top:80px;">
    <div style="background:var(--bg-primary, #fff);border-radius:12px;width:600px;max-width:90vw;max-height:70vh;display:flex;flex-direction:column;box-shadow:0 20px 60px rgba(0,0,0,0.3);">
        <div style="padding:16px 20px;border-bottom:1px solid var(--border);display:flex;justify-content:space-between;align-items:center;">
            <h5 style="margin:0;font-size:16px;">Search Product</h5>
            <button type="button" onclick="closeProductSearch()" style="background:none;border:none;font-size:20px;cursor:pointer;color:var(--text-secondary);">&times;</button>
        </div>
        <div style="padding:12px 20px;border-bottom:1px solid var(--border);">
            <input type="text" id="productSearchInput" class="form-control" placeholder="Search by name, SKU, or barcode..." style="width:100%;" autocomplete="off">
        </div>
        <div id="productSearchResults" style="flex:1;overflow-y:auto;padding:8px;min-height:200px;max-height:400px;">
            <div style="text-align:center;padding:40px;color:var(--text-secondary);">Loading products...</div>
        </div>
    </div>
</div>

<script>
let vendorItemIndex = {{ $vendorItems->count() }};
let searchTimeout = null;

function toggleGstFields() {
    const gstType = document.getElementById('gstType').value;
    const gstNumber = document.getElementById('gstNumber');
    const gstRequired = document.querySelector('.gst-required');
    
    if (gstType === 'UNREGISTERED') {
        gstNumber.disabled = true;
        gstNumber.value = '';
        gstNumber.removeAttribute('required');
        if (gstRequired) gstRequired.style.display = 'none';
    } else {
        gstNumber.disabled = false;
        gstNumber.setAttribute('required', 'required');
        if (gstRequired) gstRequired.style.display = 'inline';
    }
}

// Auto uppercase
document.getElementById('gstNumber').addEventListener('input', function() { this.value = this.value.toUpperCase(); });
document.getElementById('panNumber').addEventListener('input', function() { this.value = this.value.toUpperCase(); });
document.addEventListener('DOMContentLoaded', toggleGstFields);

// ========== VENDOR ITEMS MANAGEMENT ==========

document.getElementById('addVendorItemBtn').addEventListener('click', function() {
    openProductSearch();
});

function openProductSearch() {
    const modal = document.getElementById('productSearchModal');
    modal.style.display = 'flex';
    setTimeout(() => document.getElementById('productSearchInput').focus(), 100);
    // Auto-load all products on open
    searchProducts('');
}

function closeProductSearch() {
    document.getElementById('productSearchModal').style.display = 'none';
    document.getElementById('productSearchInput').value = '';
    document.getElementById('productSearchResults').innerHTML = '';
}

document.getElementById('productSearchModal').addEventListener('click', function(e) {
    if (e.target === this) closeProductSearch();
});

document.getElementById('productSearchInput').addEventListener('input', function() {
    clearTimeout(searchTimeout);
    const term = this.value.trim();
    document.getElementById('productSearchResults').innerHTML = '<div style="text-align:center;padding:20px;color:var(--text-secondary);">Searching...</div>';
    searchTimeout = setTimeout(() => searchProducts(term), 300);
});

function searchProducts(term) {
    fetch(`{{ route('admin.purchase.vendors.search-products') }}?q=${encodeURIComponent(term)}`)
        .then(r => r.json())
        .then(results => {
            const container = document.getElementById('productSearchResults');
            if (results.length === 0) {
                container.innerHTML = '<div style="text-align:center;padding:40px;color:var(--text-secondary);">No products found.</div>';
                return;
            }
            container.innerHTML = results.map(item => `
                <div onclick='addVendorItem(${JSON.stringify(item)})' style="padding:10px 12px;cursor:pointer;border-radius:8px;margin:2px 0;display:flex;justify-content:space-between;align-items:center;transition:background 0.15s;" onmouseover="this.style.background='var(--bg-secondary, #f5f5f5)'" onmouseout="this.style.background='none'">
                    <div>
                        <div style="font-weight:500;font-size:14px;">${item.text}</div>
                        <div style="font-size:12px;color:var(--text-secondary);">SKU: ${item.sku || '-'} | Unit: ${item.unit_name || '-'}</div>
                    </div>
                    <div style="font-weight:600;color:var(--primary, #6366f1);">₹${parseFloat(item.price || 0).toFixed(2)}</div>
                </div>
            `).join('');
        })
        .catch(err => {
            document.getElementById('productSearchResults').innerHTML = '<div style="text-align:center;padding:20px;color:var(--danger);">Error searching products.</div>';
        });
}

function addVendorItem(product) {
    // Check for duplicates
    const existing = document.querySelectorAll('input[name^="vendor_items"][name$="[product_id]"]');
    for (let inp of existing) {
        const row = inp.closest('tr');
        const varInput = row.querySelector('input[name$="[variation_id]"]');
        if (inp.value == product.product_id && (varInput.value || '') == (product.variation_id || '')) {
            alert('This product is already added.');
            return;
        }
    }

    const idx = vendorItemIndex++;
    const tbody = document.getElementById('vendorItemsBody');

    const row = document.createElement('tr');
    row.style.borderBottom = '1px solid var(--border)';
    row.innerHTML = `
        <td style="padding:10px 12px;">
            <div style="font-weight:500;font-size:13px;">${product.text}</div>
            <div style="font-size:11px;color:var(--text-secondary);margin-top:2px;">SKU: ${product.sku || '-'}</div>
            <input type="hidden" name="vendor_items[${idx}][product_id]" value="${product.product_id}">
            <input type="hidden" name="vendor_items[${idx}][variation_id]" value="${product.variation_id || ''}">
        </td>
        <td style="padding:10px 12px;">
            <input type="text" name="vendor_items[${idx}][vendor_sku]" class="form-control" placeholder="Vendor SKU" style="min-width:90px;">
        </td>
        <td style="padding:10px 12px;">
            <span style="font-size:13px;">${product.unit_name || '-'}</span>
            <input type="hidden" name="vendor_items[${idx}][unit_id]" value="${product.unit_id || ''}">
        </td>
        <td style="padding:10px 12px;">
            <input type="number" name="vendor_items[${idx}][purchase_price]" class="form-control" value="${parseFloat(product.price || 0).toFixed(2)}" step="0.01" min="0" style="text-align:right;min-width:100px;">
        </td>
        <td style="padding:10px 12px;">
            <input type="number" name="vendor_items[${idx}][moq]" class="form-control" value="1" step="0.001" min="0" style="text-align:right;min-width:70px;">
        </td>
        <td style="padding:10px 12px;">
            <input type="number" name="vendor_items[${idx}][lead_days]" class="form-control" value="0" min="0" style="text-align:right;min-width:70px;">
        </td>
        <td style="padding:10px 12px;text-align:center;">
            <input type="checkbox" name="vendor_items[${idx}][is_preferred]" value="1" style="width:18px;height:18px;cursor:pointer;">
        </td>
        <td style="padding:10px 12px;text-align:center;">
            <button type="button" onclick="removeVendorItem(this)" style="background:none;border:none;color:var(--danger, #ef4444);cursor:pointer;padding:4px;" title="Remove">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="3 6 5 6 21 6"/><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/></svg>
            </button>
        </td>
    `;
    tbody.appendChild(row);
    updateVendorItemsVisibility();
    closeProductSearch();
}

function removeVendorItem(btn) {
    if (confirm('Remove this item?')) {
        btn.closest('tr').remove();
        updateVendorItemsVisibility();
    }
}

function updateVendorItemsVisibility() {
    const rows = document.querySelectorAll('#vendorItemsBody tr');
    const table = document.getElementById('vendorItemsTable');
    const empty = document.getElementById('vendorItemsEmpty');
    if (rows.length > 0) {
        table.style.display = 'table';
        empty.style.display = 'none';
    } else {
        table.style.display = 'none';
        empty.style.display = 'block';
    }
}
</script>
