<?php

namespace Modules\Tasks\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class TaskStatus extends Model
{
    protected $table = 'module_task_statuses';

    protected $fillable = [
        'label',
        'color',
        'sort_order',
        'show_by_default',
        'is_completed',
        'is_active',
    ];

    protected $casts = [
        'show_by_default' => 'boolean',
        'is_completed' => 'boolean',
        'is_active' => 'boolean',
    ];

    public $timestamps = false;

    // ==================== RELATIONSHIPS ====================

    public function tasks()
    {
        return $this->hasMany(Task::class, 'status_id');
    }

    // ==================== SCOPES ====================

    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true);
    }

    public function scopeDefault(Builder $query): Builder
    {
        return $query->where('show_by_default', true);
    }

    public function scopeCompleted(Builder $query): Builder
    {
        return $query->where('is_completed', true);
    }
}
