<style>
.overview-page {
    padding: 20px;
}

.page-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
}

.back-link {
    display: flex;
    align-items: center;
    gap: 8px;
    text-decoration: none;
    color: #111827;
    font-weight: 500;
}

.back-link:hover {
    color: #3b82f6;
}

.action-buttons {
    display: flex;
    gap: 12px;
}

.btn {
    padding: 10px 20px;
    border-radius: 10px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.2s;
    display: inline-block;
}

.btn-primary {
    background: #3b82f6;
    color: white;
    border: none;
}

.btn-primary:hover {
    background: #2563eb;
}

.btn-secondary {
    background: #ffffff;
    color: #111827;
    border: 1px solid #e5e7eb;
}

.btn-secondary:hover {
    background: #f3f4f6;
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 24px;
}

.stat-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 12px;
    padding: 20px;
}

.stat-label {
    font-size: 13px;
    color: #9ca3af;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 8px;
}

.stat-value {
    font-size: 28px;
    font-weight: 700;
    color: #111827;
}

.stat-badge {
    display: inline-block;
    padding: 4px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    margin-top: 8px;
}

.badge-success {
    background: #d1fae5;
    color: #10b981;
}

.badge-warning {
    background: #fef3c7;
    color: #f59e0b;
}

.badge-danger {
    background: #fee2e2;
    color: #ef4444;
}

/* Progress Bar */
.progress-container {
    margin-top: 12px;
}

.progress-label {
    display: flex;
    justify-content: space-between;
    font-size: 13px;
    color: #6b7280;
    margin-bottom: 6px;
}

.progress-bar-bg {
    width: 100%;
    height: 8px;
    background: #f3f4f6;
    border-radius: 4px;
    overflow: hidden;
}

.progress-bar-fill {
    height: 100%;
    background: #3b82f6;
    border-radius: 4px;
    transition: width 0.3s ease;
}

.progress-bar-fill.success {
    background: #10b981;
}

.progress-bar-fill.warning {
    background: #f59e0b;
}

/* Content Grid */
.content-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 24px;
    margin-bottom: 24px;
}

.content-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 12px;
    overflow: hidden;
}

.card-header {
    padding: 20px;
    border-bottom: 1px solid #e5e7eb;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.card-title {
    font-size: 16px;
    font-weight: 700;
    color: #111827;
}

.card-body {
    padding: 20px;
}

/* Team List */
.team-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.team-member {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px;
    background: #f3f4f6;
    border-radius: 8px;
}

.member-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #3b82f6;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 14px;
}

.member-info {
    flex: 1;
}

.member-name {
    font-weight: 600;
    color: #111827;
    margin-bottom: 2px;
}

.member-role {
    font-size: 13px;
    color: #9ca3af;
}

/* Task List */
.task-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.task-item {
    padding: 16px;
    background: #f3f4f6;
    border-radius: 8px;
    transition: all 0.2s;
}

.task-item:hover {
    background: #e5e7eb;
}

.task-header-row {
    display: flex;
    justify-content: space-between;
    align-items: start;
    margin-bottom: 8px;
}

.task-title-link {
    font-weight: 600;
    color: #111827;
    text-decoration: none;
    flex: 1;
}

.task-title-link:hover {
    color: #3b82f6;
}

.task-status-badge {
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
}

.task-meta {
    display: flex;
    gap: 16px;
    font-size: 13px;
    color: #9ca3af;
}

.task-meta-item {
    display: flex;
    align-items: center;
    gap: 4px;
}

/* Project Details */
.detail-row {
    display: flex;
    justify-content: space-between;
    padding: 12px 0;
    border-bottom: 1px solid #e5e7eb;
}

.detail-row:last-child {
    border-bottom: none;
}

.detail-label {
    font-size: 14px;
    color: #9ca3af;
}

.detail-value {
    font-size: 14px;
    font-weight: 600;
    color: #111827;
}

/* Expenses */
.expense-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 16px;
}

.expense-item {
    padding: 16px;
    background: #f3f4f6;
    border-radius: 8px;
}

.expense-label {
    font-size: 13px;
    color: #9ca3af;
    margin-bottom: 6px;
}

.expense-value {
    font-size: 20px;
    font-weight: 700;
    color: #111827;
}

@media (max-width: 1024px) {
    .content-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 768px) {
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .expense-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="overview-page">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <a href="{{ route('admin.projects.index') }}" class="back-link">
                <span>←</span> Back to Projects
            </a>
            <h1 style="margin-top: 8px;">{{ $project->title }}</h1>
        </div>
        <div class="action-buttons">
            <a href="{{ route('admin.projects.edit', $project->id) }}" class="btn btn-secondary">Edit Project</a>
            <a href="{{ route('admin.tasks.create') }}?project_id={{ $project->id }}" class="btn btn-primary">Add Task</a>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-label">Project Progress</div>
            <div class="stat-value">{{ number_format($projectProgress, 0) }}%</div>
            <div class="progress-container">
                <div class="progress-bar-bg">
                    <div class="progress-bar-fill {{ $projectProgress >= 100 ? 'success' : ($projectProgress >= 50 ? 'warning' : '') }}" 
                         style="width: {{ $projectProgress }}%"></div>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-label">Project Status</div>
            <div class="stat-value">{{ $project->status->status_label ?? 'N/A' }}</div>
            <span class="stat-badge badge-{{ $project->status->ui_color ?? 'success' }}">
                Active
            </span>
        </div>

        <div class="stat-card">
            <div class="stat-label">Total Tasks</div>
            <div class="stat-value">{{ $totalTasks }}</div>
            <div style="font-size: 13px; color: #9ca3af; margin-top: 8px;">
                {{ $completedTasks }} completed
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-label">Team Members</div>
            <div class="stat-value">{{ $teamCount }}</div>
            <div style="font-size: 13px; color: #9ca3af; margin-top: 8px;">
                Active team members
            </div>
        </div>
    </div>

    <!-- Main Content Grid -->
    <div class="content-grid">
        <!-- Left Column -->
        <div>
            <!-- Project Details -->
            <div class="content-card" style="margin-bottom: 24px;">
                <div class="card-header">
                    <h2 class="card-title">Project Details</h2>
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">Billing Method</span>
                        <span class="detail-value">{{ ucfirst(str_replace('_', ' ', $project->billing_method)) }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Planned Start</span>
                        <span class="detail-value">{{ $project->planned_start_date ? $project->planned_start_date->format('M d, Y') : 'Not set' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Planned End</span>
                        <span class="detail-value">{{ $project->planned_end_date ? $project->planned_end_date->format('M d, Y') : 'Not set' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Is Billable</span>
                        <span class="detail-value">
                            <span class="stat-badge {{ $project->is_billable ? 'badge-success' : 'badge-warning' }}">
                                {{ $project->is_billable ? 'Yes' : 'No' }}
                            </span>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Project Expenses -->
            <div class="content-card" style="margin-bottom: 24px;">
                <div class="card-header">
                    <h2 class="card-title">Project Expenses</h2>
                </div>
                <div class="card-body">
                    <div class="expense-grid">
                        <div class="expense-item">
                            <div class="expense-label">Total Hours Logged</div>
                            <div class="expense-value">{{ number_format($totalHours, 1) }}h</div>
                        </div>
                        <div class="expense-item">
                            <div class="expense-label">Estimated Hours</div>
                            <div class="expense-value">{{ number_format($estimatedHours, 1) }}h</div>
                        </div>
                        <div class="expense-item">
                            <div class="expense-label">Total Cost</div>
                            <div class="expense-value">₹{{ number_format($totalCost, 2) }}</div>
                        </div>
                        <div class="expense-item">
                            <div class="expense-label">Remaining Budget</div>
                            <div class="expense-value">₹{{ number_format($remainingBudget, 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Assigned Tasks -->
            <div class="content-card">
                <div class="card-header">
                    <h2 class="card-title">Assigned Tasks</h2>
                    <a href="{{ route('admin.tasks.create') }}?project_id={{ $project->id }}" class="btn btn-primary" style="font-size: 14px; padding: 8px 16px;">
                        + Add Task
                    </a>
                </div>
                <div class="card-body">
                    @if($tasks->isEmpty())
                        <p style="text-align: center; color: #9ca3af; padding: 40px 20px;">
                            No tasks assigned yet. Create your first task to get started.
                        </p>
                    @else
                        <div class="task-list">
                            @foreach($tasks as $task)
                            <div class="task-item">
                                <div class="task-header-row">
                                    <a href="{{ route('admin.tasks.show', $task->id) }}" class="task-title-link">
                                        {{ $task->title }}
                                    </a>
                                    <span class="task-status-badge badge-{{ $task->status->ui_color ?? 'success' }}">
                                        {{ $task->status->status_label ?? 'N/A' }}
                                    </span>
                                </div>
                                <div class="task-meta">
                                    <span class="task-meta-item">
                                        <svg width="14" height="14" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        Priority: {{ ucfirst($task->priority) }}
                                    </span>
                                    @if($task->due_date)
                                    <span class="task-meta-item">
                                        <svg width="14" height="14" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                                            <line x1="16" y1="2" x2="16" y2="6"/>
                                            <line x1="8" y1="2" x2="8" y2="6"/>
                                            <line x1="3" y1="10" x2="21" y2="10"/>
                                        </svg>
                                        Due: {{ $task->due_date->format('M d, Y') }}
                                    </span>
                                    @endif
                                    <span class="task-meta-item">
                                        <svg width="14" height="14" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path d="M17 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2"/>
                                            <circle cx="9" cy="7" r="4"/>
                                            <path d="M23 21v-2a4 4 0 00-3-3.87m-4-12a4 4 0 010 7.75"/>
                                        </svg>
                                        {{ $task->owners->count() }} assigned
                                    </span>
                                </div>
                                
                                <!-- Task Progress -->
                                @if($task->estimated_hours)
                                <div class="progress-container">
                                    @php
                                        $taskProgress = $task->timeLogs->sum('hours_spent') > 0 && $task->estimated_hours > 0
                                            ? min(100, ($task->timeLogs->sum('hours_spent') / $task->estimated_hours) * 100)
                                            : 0;
                                    @endphp
                                    <div class="progress-label">
                                        <span>Progress</span>
                                        <span>{{ number_format($taskProgress, 0) }}%</span>
                                    </div>
                                    <div class="progress-bar-bg">
                                        <div class="progress-bar-fill {{ $taskProgress >= 100 ? 'success' : '' }}" 
                                             style="width: {{ $taskProgress }}%"></div>
                                    </div>
                                </div>
                                @endif
                            </div>
                            @endforeach
                        </div>

                        @if($tasks->hasMorePages())
                        <div style="margin-top: 20px; text-align: center;">
                            <a href="{{ route('admin.tasks.index') }}?project_id={{ $project->id }}" class="btn btn-secondary">
                                View All Tasks
                            </a>
                        </div>
                        @endif
                    @endif
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div>
            <!-- Team Members -->
            <div class="content-card">
                <div class="card-header">
                    <h2 class="card-title">Assigned Team</h2>
                </div>
                <div class="card-body">
                    @if($team->isEmpty())
                        <p style="text-align: center; color: #9ca3af; padding: 20px;">
                            No team members assigned
                        </p>
                    @else
                        <div class="team-list">
                            @foreach($team as $member)
                            <div class="team-member">
                                <div class="member-avatar">
                                    {{ strtoupper(substr($member->name, 0, 2)) }}
                                </div>
                                <div class="member-info">
                                    <div class="member-name">{{ $member->name }}</div>
                                    <div class="member-role">{{ $member->email }}</div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
