<style>
/* ========================================
   Time Log Detail - Theme-Aware Styles
   ======================================== */

/* Page Animation */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideIn {
    from { opacity: 0; transform: translateX(-20px); }
    to { opacity: 1; transform: translateX(0); }
}

.timelog-detail-page {
    padding: 2rem;
    animation: fadeIn 0.4s ease;
    max-width: 1200px;
    margin: 0 auto;
}

/* Page Header */
.page-header {
    display: flex;
    align-items: center;
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.btn-back {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 0.5rem;
    text-decoration: none;
    color: #111827;
    transition: all 0.3s ease;
}

.btn-back:hover {
    background: #3b82f6;
    border-color: #3b82f6;
    color: white;
    transform: translateY(-2px);
}

.btn-back svg {
    width: 20px;
    height: 20px;
}

.page-title-section h1 {
    font-size: 1.25rem;
    font-weight: 700;
    color: #111827;
    margin: 0 0 0.25rem 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.page-title-section h1 svg {
    width: 28px;
    height: 28px;
    color: #3b82f6;
}

.page-subtitle {
    font-size: 0.875rem;
    color: #6b7280;
    margin: 0;
}

/* Content Grid */
.content-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 2rem;
    margin-bottom: 2rem;
}

@media (max-width: 968px) {
    .content-grid {
        grid-template-columns: 1fr;
    }
}

/* Info Card */
.info-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 0.5rem;
    overflow: hidden;
    animation: slideIn 0.3s ease;
    transition: all 0.3s ease;
}

.info-card:hover {
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.card-header {
    padding: 1.5rem;
    border-bottom: 1px solid #e5e7eb;
    background: #f3f4f6;
}

.card-title {
    font-size: 1.125rem;
    font-weight: 600;
    color: #111827;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.card-title svg {
    width: 20px;
    height: 20px;
    color: #3b82f6;
}

.card-body {
    padding: 1.5rem;
}

/* Info Grid */
.info-grid {
    display: grid;
    gap: 1.5rem;
}

.info-item {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.info-label {
    font-size: 0.75rem;
    font-weight: 600;
    color: #6b7280;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.info-label svg {
    width: 14px;
    height: 14px;
    color: #9ca3af;
}

.info-value {
    font-size: 0.9375rem;
    color: #111827;
    font-weight: 500;
}

.info-value-large {
    font-size: 32px;
    font-weight: 700;
    color: #3b82f6;
    letter-spacing: -0.02em;
}

/* Status Badge */
.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 0.875rem;
    font-weight: 600;
}

.status-badge.running {
    background: #fef3c7;
    color: #f59e0b;
}

.status-badge.completed {
    background: #d1fae5;
    color: #10b981;
}

.status-badge svg {
    width: 14px;
    height: 14px;
}

/* Link Button */
.link-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 0;
    color: #3b82f6;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.2s ease;
}

.link-item:hover {
    color: #2563eb;
    transform: translateX(4px);
}

.link-item svg {
    width: 18px;
    height: 18px;
}

/* Location Card */
.location-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 0.5rem;
    overflow: hidden;
    animation: slideIn 0.4s ease;
}

.location-header {
    padding: 1.5rem;
    border-bottom: 1px solid #e5e7eb;
    background: #f3f4f6;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.location-title {
    font-size: 1.125rem;
    font-weight: 600;
    color: #111827;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.location-title svg {
    width: 20px;
    height: 20px;
    color: #10b981;
}

.btn-map {
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    padding: 8px 16px;
    background: #10b981;
    color: white;
    border-radius: 0.375rem;
    text-decoration: none;
    font-size: 0.875rem;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-map:hover {
    background: #3b82f6;
    transform: translateY(-2px);
    box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
}

.btn-map svg {
    width: 16px;
    height: 16px;
}

/* Location Details */
.location-details {
    padding: 1.5rem;
}

.location-info {
    display: grid;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.location-row {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem;
    background: #f3f4f6;
    border-radius: 0.375rem;
}

.location-row svg {
    width: 18px;
    height: 18px;
    color: #3b82f6;
    flex-shrink: 0;
}

.location-text {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.location-text-label {
    font-size: 0.75rem;
    color: #6b7280;
    font-weight: 500;
}

.location-text-value {
    font-size: 1rem;
    color: #111827;
    font-weight: 500;
    font-family: monospace;
}

/* Map Container */
.map-container {
    position: relative;
    width: 100%;
    height: 400px;
    background: #f3f4f6;
    border-radius: 0.5rem;
    overflow: hidden;
    margin-top: 1.5rem;
}

.map-frame {
    width: 100%;
    height: 100%;
    border: none;
}

.map-placeholder {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 100%;
    gap: 1rem;
}

.map-placeholder svg {
    width: 64px;
    height: 64px;
    color: #9ca3af;
}

.map-placeholder p {
    font-size: 1rem;
    color: #6b7280;
    margin: 0;
}

/* Accuracy Badge */
.accuracy-badge {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 10px;
    background: #dbeafe;
    border-radius: 12px;
    font-size: 0.75rem;
    font-weight: 600;
    color: #3b82f6;
}

.accuracy-badge svg {
    width: 12px;
    height: 12px;
}

/* No Location Message */
.no-location-card {
    background: #fef3c7;
    border: 1px solid #f59e0b;
    border-radius: 0.5rem;
    padding: 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.no-location-card svg {
    width: 40px;
    height: 40px;
    color: #f59e0b;
    flex-shrink: 0;
}

.no-location-text h4 {
    font-size: 0.9375rem;
    color: #f59e0b;
    margin: 0 0 0.25rem 0;
    font-weight: 600;
}

.no-location-text p {
    font-size: 0.875rem;
    color: #6b7280;
    margin: 0;
}

/* Divider */
.divider {
    height: 1px;
    background: #e5e7eb;
    margin: 1.5rem 0;
}
</style>

<div class="timelog-detail-page">
    {{-- Page Header --}}
    <div class="page-header">
        <a href="{{ route('admin.timelogs.index') }}" class="btn-back">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <div class="page-title-section">
            <h1>
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Time Log Details
            </h1>
            <p class="page-subtitle">Time Log #{{ $timeLog->id }} · {{ $timeLog->created_at->format('M d, Y') }}</p>
        </div>
    </div>

    {{-- Content Grid --}}
    <div class="content-grid">
        {{-- Main Details --}}
        <div>
            {{-- Task Information --}}
            <div class="info-card" style="margin-bottom: 2rem;">
                <div class="card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                        </svg>
                        Task Information
                    </h2>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                                </svg>
                                Task Name
                            </div>
                            <div class="info-value">{{ $timeLog->task->title }}</div>
                        </div>

                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                                </svg>
                                Project
                            </div>
                            <div class="info-value">
                                <a href="{{ route('admin.projects.show', $timeLog->task->project_id) }}" class="link-item" style="padding: 0;">
                                    {{ $timeLog->task->project->title }}
                                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
                                    </svg>
                                </a>
                            </div>
                        </div>

                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                                Team Member
                            </div>
                            <div class="info-value">{{ $timeLog->admin->name }}</div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Time Details --}}
            <div class="info-card">
                <div class="card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Time Details
                    </h2>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Start Time
                            </div>
                            <div class="info-value">{{ $timeLog->start_time->format('M d, Y h:i A') }}</div>
                        </div>

                        @if($timeLog->end_time)
                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                End Time
                            </div>
                            <div class="info-value">{{ $timeLog->end_time->format('M d, Y h:i A') }}</div>
                        </div>
                        @endif

                        <div class="info-item">
                            <div class="info-label">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Status
                            </div>
                            <div class="info-value">
                                @if($timeLog->is_running)
                                <span class="status-badge running">
                                    <svg fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM9.555 7.168A1 1 0 008 8v4a1 1 0 001.555.832l3-2a1 1 0 000-1.664l-3-2z" clip-rule="evenodd"/>
                                    </svg>
                                    Running
                                </span>
                                @else
                                <span class="status-badge completed">
                                    <svg fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                    </svg>
                                    Completed
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Sidebar --}}
        <div>
            {{-- Duration Card --}}
            <div class="info-card" style="margin-bottom: 2rem;">
                <div class="card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                        Duration
                    </h2>
                </div>
                <div class="card-body" style="text-align: center;">
                    <div class="info-value-large">{{ $timeLog->formatted_duration }}</div>
                    <div style="font-size: 0.875rem; color: #6b7280; margin-top: 0.5rem;">
                        @php
                            $workingSeconds = $timeLog->working_seconds;
                            if ($workingSeconds >= 3600) {
                                echo number_format($workingSeconds / 3600, 2) . ' hours';
                            } elseif ($workingSeconds >= 60) {
                                echo floor($workingSeconds / 60) . ' min ' . ($workingSeconds % 60) . ' sec';
                            } else {
                                echo $workingSeconds . ' seconds';
                            }
                        @endphp
                    </div>
                </div>
            </div>

            {{-- Billing Info --}}
            @if($timeLog->is_billable)
            <div class="info-card">
                <div class="card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Billing
                    </h2>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">Hourly Rate</div>
                            <div class="info-value">₹{{ number_format($timeLog->hourly_rate, 2) }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Billable Amount</div>
                            <div class="info-value">₹{{ number_format($timeLog->billable_amount, 2) }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Billed Status</div>
                            <div class="info-value">
                                @if($timeLog->is_billed)
                                <span class="status-badge completed">
                                    <svg fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                    </svg>
                                    Billed
                                </span>
                                @else
                                <span class="status-badge running">
                                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                    Unbilled
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>

    {{-- Start Location Section --}}
    @if($timeLog->has_location)
    <div class="location-card">
        <div class="location-header">
            <h2 class="location-title" style="color: #10b981;">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Start Location
            </h2>
            <div style="display: flex; align-items: center; gap: 0.5rem;">
                <span style="font-size: 0.875rem; color: #6b7280;">
                    {{ $timeLog->start_time->format('M d, Y - h:i A') }}
                </span>
                <a href="{{ $timeLog->google_maps_url }}" target="_blank" class="btn-map">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
                    </svg>
                    View on Map
                </a>
            </div>
        </div>

        <div class="location-details">
            <div class="location-info">
                {{-- IP Address --}}
                @if($timeLog->ip_address)
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">IP Address</div>
                        <div class="location-text-value">{{ $timeLog->ip_address }}</div>
                    </div>
                </div>
                @endif

                {{-- GPS Coordinates --}}
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">GPS Coordinates</div>
                        <div class="location-text-value">
                            {{ number_format($timeLog->latitude, 6) }}, {{ number_format($timeLog->longitude, 6) }}
                        </div>
                    </div>
                </div>

                {{-- Accuracy --}}
                @if($timeLog->location_accuracy)
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">Accuracy</div>
                        <div class="location-text-value">
                            <span class="accuracy-badge">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                ±{{ round($timeLog->location_accuracy) }} meters
                            </span>
                        </div>
                    </div>
                </div>
                @endif

                {{-- Address --}}
                @if($timeLog->location_address)
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">Address</div>
                        <div class="location-text-value">{{ $timeLog->location_address }}</div>
                    </div>
                </div>
                @endif
            </div>

            {{-- Google Maps Embed --}}
            <div class="map-container">
                <iframe 
                    class="map-frame"
                    src="https://www.google.com/maps?q={{ $timeLog->latitude }},{{ $timeLog->longitude }}&z=16&output=embed"
                    loading="lazy"
                    allowfullscreen
                    referrerpolicy="no-referrer-when-downgrade">
                </iframe>
            </div>
        </div>
    </div>
    @else
    {{-- No Start Location Data --}}
    <div class="no-location-card">
        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>
        <div class="no-location-text">
            <h4>No Start Location Data</h4>
            <p>Start location was not recorded for this time log.</p>
        </div>
    </div>
    @endif

    {{-- End Location Section --}}
    @if($timeLog->has_end_location)
    <div class="location-card" style="margin-top: 1.5rem;">
        <div class="location-header">
            <h2 class="location-title" style="color: #ef4444;">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 10a1 1 0 011-1h4a1 1 0 011 1v4a1 1 0 01-1 1h-4a1 1 0 01-1-1v-4z"/>
                </svg>
                End Location
            </h2>
            <div style="display: flex; align-items: center; gap: 0.5rem;">
                @if($timeLog->end_time)
                <span style="font-size: 0.875rem; color: #6b7280;">
                    {{ $timeLog->end_time->format('M d, Y - h:i A') }}
                </span>
                @endif
                <a href="https://www.google.com/maps?q={{ $timeLog->end_latitude }},{{ $timeLog->end_longitude }}" target="_blank" class="btn-map">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
                    </svg>
                    View on Map
                </a>
            </div>
        </div>

        <div class="location-details">
            <div class="location-info">
                {{-- IP Address --}}
                @if($timeLog->end_ip_address)
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">IP Address</div>
                        <div class="location-text-value">{{ $timeLog->end_ip_address }}</div>
                    </div>
                </div>
                @endif

                {{-- GPS Coordinates --}}
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">GPS Coordinates</div>
                        <div class="location-text-value">
                            {{ number_format($timeLog->end_latitude, 6) }}, {{ number_format($timeLog->end_longitude, 6) }}
                        </div>
                    </div>
                </div>

                {{-- Accuracy --}}
                @if($timeLog->end_location_accuracy)
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">Accuracy</div>
                        <div class="location-text-value">
                            <span class="accuracy-badge">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                ±{{ round($timeLog->end_location_accuracy) }} meters
                            </span>
                        </div>
                    </div>
                </div>
                @endif

                {{-- Address --}}
                @if($timeLog->end_location_address)
                <div class="location-row">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                    </svg>
                    <div class="location-text">
                        <div class="location-text-label">Address</div>
                        <div class="location-text-value">{{ $timeLog->end_location_address }}</div>
                    </div>
                </div>
                @endif
            </div>

            {{-- Google Maps Embed --}}
            <div class="map-container">
                <iframe 
                    class="map-frame"
                    src="https://www.google.com/maps?q={{ $timeLog->end_latitude }},{{ $timeLog->end_longitude }}&z=16&output=embed"
                    loading="lazy"
                    allowfullscreen
                    referrerpolicy="no-referrer-when-downgrade">
                </iframe>
            </div>
        </div>
    </div>
    @elseif($timeLog->end_time && !$timeLog->is_running)
    {{-- No End Location Data (but timer was stopped) --}}
    <div class="no-location-card" style="margin-top: 1.5rem;">
        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>
        <div class="no-location-text">
            <h4>No End Location Data</h4>
            <p>End location was not recorded when the timer was stopped.</p>
        </div>
    </div>
    @endif
</div>